/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtils;

public final class ColumnExtractor {
    public static Collection<ColumnSegment> extract(ExpressionSegment expression) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (expression instanceof BinaryOperationExpression) {
            if (((BinaryOperationExpression)expression).getLeft() instanceof ColumnSegment) {
                result.add((ColumnSegment)((BinaryOperationExpression)expression).getLeft());
            }
            if (((BinaryOperationExpression)expression).getRight() instanceof ColumnSegment) {
                result.add((ColumnSegment)((BinaryOperationExpression)expression).getRight());
            }
        }
        if (expression instanceof InExpression && ((InExpression)expression).getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)((InExpression)expression).getLeft());
        }
        if (expression instanceof BetweenExpression && ((BetweenExpression)expression).getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)((BetweenExpression)expression).getLeft());
        }
        return result;
    }

    public static void extractColumnSegments(Collection<ColumnSegment> columnSegments, Collection<WhereSegment> whereSegments) {
        for (WhereSegment each : whereSegments) {
            for (AndPredicate andPredicate : ExpressionExtractUtils.getAndPredicates(each.getExpr())) {
                ColumnExtractor.extractColumnSegments(columnSegments, andPredicate);
            }
        }
    }

    private static void extractColumnSegments(Collection<ColumnSegment> columnSegments, AndPredicate andPredicate) {
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            columnSegments.addAll(ColumnExtractor.extract(each));
        }
    }

    @Generated
    private ColumnExtractor() {
    }
}

