/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.ComplexExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtils;

public final class ExpressionProjectionSegment
implements ProjectionSegment,
ComplexExpressionSegment,
AliasAvailable {
    private final int startIndex;
    private final int stopIndex;
    private final String text;
    private final ExpressionSegment expr;
    private AliasSegment alias;

    public ExpressionProjectionSegment(int startIndex, int stopIndex, String text) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.text = SQLUtils.getExpressionWithoutOutsideParentheses(text);
        this.expr = null;
    }

    public ExpressionProjectionSegment(int startIndex, int stopIndex, String text, ExpressionSegment expr) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.text = SQLUtils.getExpressionWithoutOutsideParentheses(text);
        this.expr = expr;
    }

    @Override
    public Optional<String> getAliasName() {
        return null == this.alias ? Optional.empty() : Optional.ofNullable(this.alias.getIdentifier().getValue());
    }

    @Override
    public Optional<AliasSegment> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public int getStopIndex() {
        return null != this.alias ? this.alias.getStopIndex() : this.stopIndex;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public ExpressionSegment getExpr() {
        return this.expr;
    }

    @Override
    @Generated
    public void setAlias(AliasSegment alias) {
        this.alias = alias;
    }
}

