/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.enums.DirectionType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.ValidateConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.DirectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.NameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterAggregateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterCollationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterConversionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterDefaultPrivilegesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterDomainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterExtensionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterForeignDataWrapperStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterForeignTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterLanguageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterOperatorStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterPolicyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterPublicationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterRoutineStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterStatisticsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterSubscriptionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterTextSearchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterTypeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLAlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCloseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLClusterStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCommentStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateAccessMethodStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateAggregateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateCastStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateCollationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateConversionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateDomainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateEventTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateExtensionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateForeignDataWrapperStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateForeignTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateLanguageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateOperatorStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreatePolicyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreatePublicationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateTextSearchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateTypeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLCreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDeallocateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDeclareStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDiscardStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropAccessMethodStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropAggregateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropCastStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropCollationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropConversionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropDomainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropEventTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropExtensionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropForeignDataWrapperStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropForeignTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropLanguageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropOperatorClassStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropOperatorFamilyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropOperatorStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropOwnedStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropPolicyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropPublicationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropRoutineStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropSequenceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropStatisticsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropSubscriptionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropTextSearchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropTypeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLDropViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLFetchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLListenStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLMoveStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLNotifyStmtStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLPrepareStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLRefreshMatViewStmtStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLReindexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLSecurityLabelStmtStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLTruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLUnlistenStatement;

public final class PostgreSQLDDLStatementVisitor
extends PostgreSQLStatementVisitor
implements DDLStatementVisitor {
    @Override
    public ASTNode visitCreateTable(PostgreSQLStatementParser.CreateTableContext ctx) {
        PostgreSQLCreateTableStatement result = new PostgreSQLCreateTableStatement(null != ctx.ifNotExists());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(PostgreSQLStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(PostgreSQLStatementParser.AlterTableContext ctx) {
        PostgreSQLAlterTableStatement result = new PostgreSQLAlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause().tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ValidateConstraintDefinitionSegment) {
                    result.getValidateConstraintDefinitions().add((ValidateConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyConstraintDefinitionSegment) {
                    result.getModifyConstraintDefinitions().add((ModifyConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropConstraintDefinitionSegment) {
                    result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof RenameTableDefinitionSegment) {
                    result.setRenameTable(((RenameTableDefinitionSegment)each).getRenameTable());
                    continue;
                }
                if (!(each instanceof RenameColumnSegment)) continue;
                result.getRenameColumnDefinitions().add((RenameColumnSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterAggregate(PostgreSQLStatementParser.AlterAggregateContext ctx) {
        return new PostgreSQLAlterAggregateStatement();
    }

    @Override
    public ASTNode visitAlterCollation(PostgreSQLStatementParser.AlterCollationContext ctx) {
        return new PostgreSQLAlterCollationStatement();
    }

    @Override
    public ASTNode visitAlterDefaultPrivileges(PostgreSQLStatementParser.AlterDefaultPrivilegesContext ctx) {
        return new PostgreSQLAlterDefaultPrivilegesStatement();
    }

    @Override
    public ASTNode visitAlterForeignDataWrapper(PostgreSQLStatementParser.AlterForeignDataWrapperContext ctx) {
        return new PostgreSQLAlterForeignDataWrapperStatement();
    }

    @Override
    public ASTNode visitAlterDefinitionClause(PostgreSQLStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterTableActions()) {
            result.getValue().addAll(ctx.alterTableActions().alterTableAction().stream().flatMap(each -> this.getAlterDefinitionSegments((PostgreSQLStatementParser.AlterTableActionContext)((Object)each)).stream()).collect(Collectors.toList()));
        }
        if (null != ctx.renameColumnSpecification()) {
            result.getValue().add((RenameColumnSegment)this.visit((ParseTree)ctx.renameColumnSpecification()));
        }
        if (null != ctx.renameTableSpecification()) {
            result.getValue().add((RenameTableDefinitionSegment)this.visit((ParseTree)ctx.renameTableSpecification()));
        }
        return result;
    }

    private Collection<AlterDefinitionSegment> getAlterDefinitionSegments(PostgreSQLStatementParser.AlterTableActionContext ctx) {
        LinkedList<AlterDefinitionSegment> result = new LinkedList<AlterDefinitionSegment>();
        if (null != ctx.addColumnSpecification()) {
            result.addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.addConstraintSpecification() && null != ctx.addConstraintSpecification().tableConstraint()) {
            result.add((AlterDefinitionSegment)((AddConstraintDefinitionSegment)this.visit((ParseTree)ctx.addConstraintSpecification())));
        }
        if (null != ctx.validateConstraintSpecification()) {
            result.add((AlterDefinitionSegment)((ValidateConstraintDefinitionSegment)this.visit((ParseTree)ctx.validateConstraintSpecification())));
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.add((AlterDefinitionSegment)((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification())));
        }
        if (null != ctx.modifyConstraintSpecification()) {
            result.add((AlterDefinitionSegment)((ModifyConstraintDefinitionSegment)this.visit((ParseTree)ctx.modifyConstraintSpecification())));
        }
        if (null != ctx.dropColumnSpecification()) {
            result.add((AlterDefinitionSegment)((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.dropColumnSpecification())));
        }
        if (null != ctx.dropConstraintSpecification()) {
            result.add((AlterDefinitionSegment)((DropConstraintDefinitionSegment)this.visit((ParseTree)ctx.dropConstraintSpecification())));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterForeignTable(PostgreSQLStatementParser.AlterForeignTableContext ctx) {
        return new PostgreSQLAlterForeignTableStatement();
    }

    @Override
    public ASTNode visitDropForeignTable(PostgreSQLStatementParser.DropForeignTableContext ctx) {
        return new PostgreSQLDropForeignTableStatement();
    }

    @Override
    public ASTNode visitAlterGroup(PostgreSQLStatementParser.AlterGroupContext ctx) {
        return new PostgreSQLAlterGroupStatement();
    }

    @Override
    public ASTNode visitAlterMaterializedView(PostgreSQLStatementParser.AlterMaterializedViewContext ctx) {
        return new PostgreSQLAlterMaterializedViewStatement();
    }

    @Override
    public ASTNode visitAlterOperator(PostgreSQLStatementParser.AlterOperatorContext ctx) {
        return new PostgreSQLAlterOperatorStatement();
    }

    @Override
    public ASTNode visitAddConstraintSpecification(PostgreSQLStatementParser.AddConstraintSpecificationContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.tableConstraint()));
    }

    @Override
    public ASTNode visitValidateConstraintSpecification(PostgreSQLStatementParser.ValidateConstraintSpecificationContext ctx) {
        return new ValidateConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitModifyConstraintSpecification(PostgreSQLStatementParser.ModifyConstraintSpecificationContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitDropConstraintSpecification(PostgreSQLStatementParser.DropConstraintSpecificationContext ctx) {
        return new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterDomain(PostgreSQLStatementParser.AlterDomainContext ctx) {
        return new PostgreSQLAlterDomainStatement();
    }

    @Override
    public ASTNode visitAlterPolicy(PostgreSQLStatementParser.AlterPolicyContext ctx) {
        return new PostgreSQLAlterPolicyStatement();
    }

    @Override
    public ASTNode visitAlterPublication(PostgreSQLStatementParser.AlterPublicationContext ctx) {
        return new PostgreSQLAlterPublicationStatement();
    }

    @Override
    public ASTNode visitAlterSubscription(PostgreSQLStatementParser.AlterSubscriptionContext ctx) {
        return new PostgreSQLAlterSubscriptionStatement();
    }

    @Override
    public ASTNode visitAlterTrigger(PostgreSQLStatementParser.AlterTriggerContext ctx) {
        return new PostgreSQLAlterTriggerStatement();
    }

    @Override
    public ASTNode visitAlterType(PostgreSQLStatementParser.AlterTypeContext ctx) {
        return new PostgreSQLAlterTypeStatement();
    }

    @Override
    public ASTNode visitRenameTableSpecification(PostgreSQLStatementParser.RenameTableSpecificationContext ctx) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        TableNameSegment tableName = new TableNameSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        result.setRenameTable(new SimpleTableSegment(tableName));
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(PostgreSQLStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        PostgreSQLStatementParser.ColumnDefinitionContext columnDefinition = ctx.columnDefinition();
        if (null != columnDefinition) {
            AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(ctx.columnDefinition().getStart().getStartIndex(), columnDefinition.getStop().getStopIndex(), Collections.singleton((ColumnDefinitionSegment)this.visit((ParseTree)columnDefinition)));
            result.getValue().add(addColumnDefinition);
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(PostgreSQLStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.columnConstraint().stream().anyMatch(each -> null != each.columnConstraintOption() && null != each.columnConstraintOption().primaryKey());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false);
        for (PostgreSQLStatementParser.ColumnConstraintContext each2 : ctx.columnConstraint()) {
            if (null == each2.columnConstraintOption().tableName()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each2.columnConstraintOption().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraintUsingIndex(PostgreSQLStatementParser.TableConstraintUsingIndexContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraint(PostgreSQLStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintClause()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintClause().constraintName()));
        }
        if (null != ctx.tableConstraintOption().primaryKey()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableConstraintOption().columnNames(0))).getValue());
        }
        if (null != ctx.tableConstraintOption().FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableConstraintOption().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(PostgreSQLStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.modifyColumn().columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false);
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(PostgreSQLStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singleton((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitRenameColumnSpecification(PostgreSQLStatementParser.RenameColumnSpecificationContext ctx) {
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)this.visit((ParseTree)ctx.columnName(0)), (ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
    }

    @Override
    public ASTNode visitDropTable(PostgreSQLStatementParser.DropTableContext ctx) {
        boolean containsCascade = ctx.dropTableOpt() != null && null != ctx.dropTableOpt().CASCADE();
        PostgreSQLDropTableStatement result = new PostgreSQLDropTableStatement(null != ctx.ifExists(), containsCascade);
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(PostgreSQLStatementParser.TruncateTableContext ctx) {
        PostgreSQLTruncateStatement result = new PostgreSQLTruncateStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNamesClause())).getValue());
        return result;
    }

    @Override
    public ASTNode visitDropPolicy(PostgreSQLStatementParser.DropPolicyContext ctx) {
        return new PostgreSQLDropPolicyStatement();
    }

    @Override
    public ASTNode visitDropRule(PostgreSQLStatementParser.DropRuleContext ctx) {
        return new PostgreSQLDropRuleStatement();
    }

    @Override
    public ASTNode visitDropStatistics(PostgreSQLStatementParser.DropStatisticsContext ctx) {
        return new PostgreSQLDropStatisticsStatement();
    }

    @Override
    public ASTNode visitDropPublication(PostgreSQLStatementParser.DropPublicationContext ctx) {
        return new PostgreSQLDropPublicationStatement();
    }

    @Override
    public ASTNode visitDropSubscription(PostgreSQLStatementParser.DropSubscriptionContext ctx) {
        return new PostgreSQLDropSubscriptionStatement();
    }

    @Override
    public ASTNode visitCreateIndex(PostgreSQLStatementParser.CreateIndexContext ctx) {
        PostgreSQLCreateIndexStatement result = new PostgreSQLCreateIndexStatement(null != ctx.ifNotExists());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.indexParams())).getValue());
        if (null != ctx.indexName()) {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        } else {
            result.setGeneratedIndexStartIndex(Integer.valueOf(ctx.ON().getSymbol().getStartIndex() - 1));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexParams(PostgreSQLStatementParser.IndexParamsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.IndexElemContext each : ctx.indexElem()) {
            if (null != each.colId()) {
                result.getValue().add(new ColumnSegment(each.colId().start.getStartIndex(), each.colId().stop.getStopIndex(), new IdentifierValue(each.colId().getText())));
            }
            if (null == each.functionExprWindowless()) continue;
            FunctionSegment functionSegment = (FunctionSegment)this.visit((ParseTree)each.functionExprWindowless());
            functionSegment.getParameters().forEach(param -> {
                if (param instanceof ColumnSegment) {
                    result.getValue().add((ColumnSegment)param);
                }
            });
        }
        return result;
    }

    @Override
    public ASTNode visitFunctionExprWindowless(PostgreSQLStatementParser.FunctionExprWindowlessContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcApplication().funcName().getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx.funcApplication().funcArgList().funcArgExpr()));
        return result;
    }

    private Collection<ExpressionSegment> getExpressions(Collection<PostgreSQLStatementParser.FuncArgExprContext> aExprContexts) {
        if (null == aExprContexts) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(aExprContexts.size());
        for (PostgreSQLStatementParser.FuncArgExprContext each : aExprContexts) {
            result.add((ExpressionSegment)this.visit((ParseTree)each.aExpr()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(PostgreSQLStatementParser.AlterIndexContext ctx) {
        PostgreSQLAlterIndexStatement result = new PostgreSQLAlterIndexStatement();
        result.setIndex(this.createIndexSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())));
        if (null != ctx.alterIndexDefinitionClause().renameIndexSpecification()) {
            result.setRenameIndex((IndexSegment)this.visit((ParseTree)ctx.alterIndexDefinitionClause().renameIndexSpecification().indexName()));
        }
        return result;
    }

    private IndexSegment createIndexSegment(SimpleTableSegment tableSegment) {
        IndexNameSegment indexName = new IndexNameSegment(tableSegment.getTableName().getStartIndex(), tableSegment.getTableName().getStopIndex(), tableSegment.getTableName().getIdentifier());
        IndexSegment result = new IndexSegment(tableSegment.getStartIndex(), tableSegment.getStopIndex(), indexName);
        tableSegment.getOwner().ifPresent(arg_0 -> ((IndexSegment)result).setOwner(arg_0));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(PostgreSQLStatementParser.DropIndexContext ctx) {
        PostgreSQLDropIndexStatement result = new PostgreSQLDropIndexStatement(null != ctx.ifExists());
        result.getIndexes().addAll(this.createIndexSegments(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue()));
        return result;
    }

    private Collection<IndexSegment> createIndexSegments(Collection<SimpleTableSegment> tableSegments) {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        for (SimpleTableSegment each : tableSegments) {
            result.add(this.createIndexSegment(each));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexNames(PostgreSQLStatementParser.IndexNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getValue().add((IndexSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitTableNameClause(PostgreSQLStatementParser.TableNameClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitTableNamesClause(PostgreSQLStatementParser.TableNamesClauseContext ctx) {
        LinkedList<SimpleTableSegment> tableSegments = new LinkedList<SimpleTableSegment>();
        for (int i = 0; i < ctx.tableNameClause().size(); ++i) {
            tableSegments.add((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause(i)));
        }
        CollectionValue result = new CollectionValue();
        result.getValue().addAll(tableSegments);
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(PostgreSQLStatementParser.AlterFunctionContext ctx) {
        return new PostgreSQLAlterFunctionStatement();
    }

    @Override
    public ASTNode visitAlterProcedure(PostgreSQLStatementParser.AlterProcedureContext ctx) {
        return new PostgreSQLAlterProcedureStatement();
    }

    @Override
    public ASTNode visitCreateFunction(PostgreSQLStatementParser.CreateFunctionContext ctx) {
        return new PostgreSQLCreateFunctionStatement();
    }

    @Override
    public ASTNode visitCreateProcedure(PostgreSQLStatementParser.CreateProcedureContext ctx) {
        return new PostgreSQLCreateProcedureStatement();
    }

    @Override
    public ASTNode visitDropFunction(PostgreSQLStatementParser.DropFunctionContext ctx) {
        return new PostgreSQLDropFunctionStatement();
    }

    @Override
    public ASTNode visitDropGroup(PostgreSQLStatementParser.DropGroupContext ctx) {
        return new PostgreSQLDropGroupStatement();
    }

    @Override
    public ASTNode visitDropView(PostgreSQLStatementParser.DropViewContext ctx) {
        PostgreSQLDropViewStatement result = new PostgreSQLDropViewStatement();
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateView(PostgreSQLStatementParser.CreateViewContext ctx) {
        PostgreSQLCreateViewStatement result = new PostgreSQLCreateViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitAlterView(PostgreSQLStatementParser.AlterViewContext ctx) {
        PostgreSQLAlterViewStatement result = new PostgreSQLAlterViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        if (ctx.alterViewClauses() instanceof PostgreSQLStatementParser.AlterRenameViewContext) {
            PostgreSQLStatementParser.NameContext nameContext = ((PostgreSQLStatementParser.AlterRenameViewContext)ctx.alterViewClauses()).name();
            result.setRenameView(new SimpleTableSegment(new TableNameSegment(nameContext.getStart().getStartIndex(), nameContext.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)nameContext.identifier()))));
        }
        return result;
    }

    @Override
    public ASTNode visitDropDatabase(PostgreSQLStatementParser.DropDatabaseContext ctx) {
        PostgreSQLDropDatabaseStatement result = new PostgreSQLDropDatabaseStatement();
        result.setDatabaseName(((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue());
        result.setIfExists(null != ctx.ifExists());
        return result;
    }

    @Override
    public ASTNode visitAlterRoutine(PostgreSQLStatementParser.AlterRoutineContext ctx) {
        return new PostgreSQLAlterRoutineStatement();
    }

    @Override
    public ASTNode visitAlterRule(PostgreSQLStatementParser.AlterRuleContext ctx) {
        return new PostgreSQLAlterRuleStatement();
    }

    @Override
    public ASTNode visitDropProcedure(PostgreSQLStatementParser.DropProcedureContext ctx) {
        return new PostgreSQLDropProcedureStatement();
    }

    @Override
    public ASTNode visitDropRoutine(PostgreSQLStatementParser.DropRoutineContext ctx) {
        return new PostgreSQLDropRoutineStatement();
    }

    @Override
    public ASTNode visitCreateDatabase(PostgreSQLStatementParser.CreateDatabaseContext ctx) {
        PostgreSQLCreateDatabaseStatement result = new PostgreSQLCreateDatabaseStatement();
        result.setDatabaseName(((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateSequence(PostgreSQLStatementParser.CreateSequenceContext ctx) {
        PostgreSQLCreateSequenceStatement result = new PostgreSQLCreateSequenceStatement();
        result.setSequenceName(((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())).getTableName().getIdentifier().getValue());
        return result;
    }

    @Override
    public ASTNode visitAlterSequence(PostgreSQLStatementParser.AlterSequenceContext ctx) {
        PostgreSQLAlterSequenceStatement result = new PostgreSQLAlterSequenceStatement();
        result.setSequenceName(((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())).getTableName().getIdentifier().getValue());
        return result;
    }

    @Override
    public ASTNode visitDropSequence(PostgreSQLStatementParser.DropSequenceContext ctx) {
        PostgreSQLDropSequenceStatement result = new PostgreSQLDropSequenceStatement();
        result.setSequenceNames(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitPrepare(PostgreSQLStatementParser.PrepareContext ctx) {
        PostgreSQLPrepareStatement result = new PostgreSQLPrepareStatement();
        if (null != ctx.preparableStmt().select()) {
            result.setSelect((SelectStatement)this.visit((ParseTree)ctx.preparableStmt().select()));
        }
        if (null != ctx.preparableStmt().insert()) {
            result.setInsert((InsertStatement)this.visit((ParseTree)ctx.preparableStmt().insert()));
        }
        if (null != ctx.preparableStmt().update()) {
            result.setUpdate((UpdateStatement)this.visit((ParseTree)ctx.preparableStmt().update()));
        }
        if (null != ctx.preparableStmt().delete()) {
            result.setDelete((DeleteStatement)this.visit((ParseTree)ctx.preparableStmt().delete()));
        }
        return result;
    }

    @Override
    public ASTNode visitDeallocate(PostgreSQLStatementParser.DeallocateContext ctx) {
        return new PostgreSQLDeallocateStatement();
    }

    @Override
    public ASTNode visitDropCast(PostgreSQLStatementParser.DropCastContext ctx) {
        return new PostgreSQLDropCastStatement();
    }

    @Override
    public ASTNode visitCreateTablespace(PostgreSQLStatementParser.CreateTablespaceContext ctx) {
        return new PostgreSQLCreateTablespaceStatement();
    }

    @Override
    public ASTNode visitAlterTablespace(PostgreSQLStatementParser.AlterTablespaceContext ctx) {
        return new PostgreSQLAlterTablespaceStatement();
    }

    @Override
    public ASTNode visitDropTablespace(PostgreSQLStatementParser.DropTablespaceContext ctx) {
        return new PostgreSQLDropTablespaceStatement();
    }

    @Override
    public ASTNode visitDropTextSearch(PostgreSQLStatementParser.DropTextSearchContext ctx) {
        return new PostgreSQLDropTextSearchStatement();
    }

    @Override
    public ASTNode visitDropDomain(PostgreSQLStatementParser.DropDomainContext ctx) {
        return new PostgreSQLDropDomainStatement();
    }

    @Override
    public ASTNode visitCreateDomain(PostgreSQLStatementParser.CreateDomainContext ctx) {
        return new PostgreSQLCreateDomainStatement();
    }

    @Override
    public ASTNode visitCreateRule(PostgreSQLStatementParser.CreateRuleContext ctx) {
        return new PostgreSQLCreateRuleStatement();
    }

    @Override
    public ASTNode visitCreateLanguage(PostgreSQLStatementParser.CreateLanguageContext ctx) {
        return new PostgreSQLCreateLanguageStatement();
    }

    @Override
    public ASTNode visitCreateSchema(PostgreSQLStatementParser.CreateSchemaContext ctx) {
        PostgreSQLCreateSchemaStatement result = new PostgreSQLCreateSchemaStatement();
        if (null != ctx.createSchemaClauses().colId()) {
            result.setSchemaName(new IdentifierValue(ctx.createSchemaClauses().colId().getText()));
        }
        if (null != ctx.createSchemaClauses().roleSpec() && null != ctx.createSchemaClauses().roleSpec().identifier()) {
            result.setUsername((IdentifierValue)this.visit((ParseTree)ctx.createSchemaClauses().roleSpec().identifier()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterSchema(PostgreSQLStatementParser.AlterSchemaContext ctx) {
        PostgreSQLAlterSchemaStatement result = new PostgreSQLAlterSchemaStatement();
        result.setSchemaName((IdentifierValue)this.visit((ParseTree)ctx.name().get(0)));
        if (ctx.name().size() > 1) {
            result.setRenameSchema((IdentifierValue)this.visit((ParseTree)ctx.name().get(1)));
        }
        return result;
    }

    @Override
    public ASTNode visitDropSchema(PostgreSQLStatementParser.DropSchemaContext ctx) {
        PostgreSQLDropSchemaStatement result = new PostgreSQLDropSchemaStatement();
        result.getSchemaNames().addAll(((CollectionValue)this.visit((ParseTree)ctx.nameList())).getValue());
        result.setContainsCascade(null != ctx.dropBehavior() && null != ctx.dropBehavior().CASCADE());
        return result;
    }

    @Override
    public ASTNode visitNameList(PostgreSQLStatementParser.NameListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.nameList()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.nameList()));
        }
        if (null != ctx.name()) {
            result.getValue().add((IdentifierValue)this.visit((ParseTree)ctx.name()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterLanguage(PostgreSQLStatementParser.AlterLanguageContext ctx) {
        return new PostgreSQLAlterLanguageStatement();
    }

    @Override
    public ASTNode visitAlterServer(PostgreSQLStatementParser.AlterServerContext ctx) {
        return new PostgreSQLAlterServerStatement();
    }

    @Override
    public ASTNode visitAlterStatistics(PostgreSQLStatementParser.AlterStatisticsContext ctx) {
        return new PostgreSQLAlterStatisticsStatement();
    }

    @Override
    public ASTNode visitDropLanguage(PostgreSQLStatementParser.DropLanguageContext ctx) {
        return new PostgreSQLDropLanguageStatement();
    }

    @Override
    public ASTNode visitCreateConversion(PostgreSQLStatementParser.CreateConversionContext ctx) {
        return new PostgreSQLCreateConversionStatement();
    }

    @Override
    public ASTNode visitCreateType(PostgreSQLStatementParser.CreateTypeContext ctx) {
        return new PostgreSQLCreateTypeStatement();
    }

    @Override
    public ASTNode visitDropConversion(PostgreSQLStatementParser.DropConversionContext ctx) {
        return new PostgreSQLDropConversionStatement();
    }

    @Override
    public ASTNode visitAlterConversion(PostgreSQLStatementParser.AlterConversionContext ctx) {
        return new PostgreSQLAlterConversionStatement();
    }

    @Override
    public ASTNode visitCreateTextSearch(PostgreSQLStatementParser.CreateTextSearchContext ctx) {
        return new PostgreSQLCreateTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchConfiguration(PostgreSQLStatementParser.AlterTextSearchConfigurationContext ctx) {
        return new PostgreSQLAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchDictionary(PostgreSQLStatementParser.AlterTextSearchDictionaryContext ctx) {
        return new PostgreSQLAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchTemplate(PostgreSQLStatementParser.AlterTextSearchTemplateContext ctx) {
        return new PostgreSQLAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchParser(PostgreSQLStatementParser.AlterTextSearchParserContext ctx) {
        return new PostgreSQLAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitCreateExtension(PostgreSQLStatementParser.CreateExtensionContext ctx) {
        return new PostgreSQLCreateExtensionStatement();
    }

    @Override
    public ASTNode visitAlterExtension(PostgreSQLStatementParser.AlterExtensionContext ctx) {
        return new PostgreSQLAlterExtensionStatement();
    }

    @Override
    public ASTNode visitDropExtension(PostgreSQLStatementParser.DropExtensionContext ctx) {
        return new PostgreSQLDropExtensionStatement();
    }

    @Override
    public ASTNode visitDiscard(PostgreSQLStatementParser.DiscardContext ctx) {
        return new PostgreSQLDiscardStatement();
    }

    @Override
    public ASTNode visitDropOwned(PostgreSQLStatementParser.DropOwnedContext ctx) {
        return new PostgreSQLDropOwnedStatement();
    }

    @Override
    public ASTNode visitDropOperator(PostgreSQLStatementParser.DropOperatorContext ctx) {
        return new PostgreSQLDropOperatorStatement();
    }

    @Override
    public ASTNode visitDropMaterializedView(PostgreSQLStatementParser.DropMaterializedViewContext ctx) {
        return new PostgreSQLDropMaterializedViewStatement();
    }

    @Override
    public ASTNode visitDropEventTrigger(PostgreSQLStatementParser.DropEventTriggerContext ctx) {
        return new PostgreSQLDropEventTriggerStatement();
    }

    @Override
    public ASTNode visitDropAggregate(PostgreSQLStatementParser.DropAggregateContext ctx) {
        return new PostgreSQLDropAggregateStatement();
    }

    @Override
    public ASTNode visitDropCollation(PostgreSQLStatementParser.DropCollationContext ctx) {
        return new PostgreSQLDropCollationStatement();
    }

    @Override
    public ASTNode visitDropForeignDataWrapper(PostgreSQLStatementParser.DropForeignDataWrapperContext ctx) {
        return new PostgreSQLDropForeignDataWrapperStatement();
    }

    @Override
    public ASTNode visitDropTrigger(PostgreSQLStatementParser.DropTriggerContext ctx) {
        return new PostgreSQLDropTriggerStatement();
    }

    @Override
    public ASTNode visitDropType(PostgreSQLStatementParser.DropTypeContext ctx) {
        return new PostgreSQLDropTypeStatement();
    }

    @Override
    public ASTNode visitComment(PostgreSQLStatementParser.CommentContext ctx) {
        if (null != ctx.commentClauses().objectTypeAnyName() && null != ctx.commentClauses().objectTypeAnyName().TABLE()) {
            return this.commentOnTable(ctx);
        }
        if (null != ctx.commentClauses().COLUMN()) {
            return this.commentOnColumn(ctx);
        }
        if (null != ctx.commentClauses().objectTypeNameOnAnyName()) {
            return this.getTableFromComment(ctx);
        }
        return new PostgreSQLCommentStatement();
    }

    private PostgreSQLCommentStatement commentOnColumn(PostgreSQLStatementParser.CommentContext ctx) {
        PostgreSQLCommentStatement result = new PostgreSQLCommentStatement();
        Iterator<NameSegment> nameSegmentIterator = ((CollectionValue)this.visit((ParseTree)ctx.commentClauses().anyName())).getValue().iterator();
        Optional<NameSegment> columnName = nameSegmentIterator.hasNext() ? Optional.of((NameSegment)nameSegmentIterator.next()) : Optional.empty();
        columnName.ifPresent(optional -> result.setColumn(new ColumnSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier())));
        result.setComment(new IdentifierValue(ctx.commentClauses().commentText().getText()));
        this.setTableSegment(result, nameSegmentIterator);
        return result;
    }

    private PostgreSQLCommentStatement commentOnTable(PostgreSQLStatementParser.CommentContext ctx) {
        PostgreSQLCommentStatement result = new PostgreSQLCommentStatement();
        Iterator<NameSegment> nameSegmentIterator = ((CollectionValue)this.visit((ParseTree)ctx.commentClauses().anyName())).getValue().iterator();
        result.setComment(new IdentifierValue(ctx.commentClauses().commentText().getText()));
        this.setTableSegment(result, nameSegmentIterator);
        return result;
    }

    private void setTableSegment(PostgreSQLCommentStatement statement, Iterator<NameSegment> nameSegmentIterator) {
        Optional<NameSegment> tableName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        tableName.ifPresent(optional -> statement.setTable(new SimpleTableSegment(new TableNameSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier()))));
        Optional<NameSegment> schemaName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        schemaName.ifPresent(optional -> statement.getTable().setOwner(new OwnerSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier())));
        Optional<NameSegment> databaseName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        databaseName.ifPresent(optional -> statement.getTable().getOwner().ifPresent(owner -> owner.setOwner(new OwnerSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier()))));
    }

    private PostgreSQLCommentStatement getTableFromComment(PostgreSQLStatementParser.CommentContext ctx) {
        PostgreSQLCommentStatement result = new PostgreSQLCommentStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.commentClauses().tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropOperatorClass(PostgreSQLStatementParser.DropOperatorClassContext ctx) {
        return new PostgreSQLDropOperatorClassStatement();
    }

    @Override
    public ASTNode visitDropOperatorFamily(PostgreSQLStatementParser.DropOperatorFamilyContext ctx) {
        return new PostgreSQLDropOperatorFamilyStatement();
    }

    @Override
    public ASTNode visitDropAccessMethod(PostgreSQLStatementParser.DropAccessMethodContext ctx) {
        return new PostgreSQLDropAccessMethodStatement();
    }

    @Override
    public ASTNode visitDropServer(PostgreSQLStatementParser.DropServerContext ctx) {
        return new PostgreSQLDropServerStatement();
    }

    @Override
    public ASTNode visitDeclare(PostgreSQLStatementParser.DeclareContext ctx) {
        PostgreSQLDeclareStatement result = new PostgreSQLDeclareStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitFetch(PostgreSQLStatementParser.FetchContext ctx) {
        PostgreSQLFetchStatement result = new PostgreSQLFetchStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        if (null != ctx.direction()) {
            result.setDirection((DirectionSegment)this.visit((ParseTree)ctx.direction()));
        }
        return result;
    }

    @Override
    public ASTNode visitMove(PostgreSQLStatementParser.MoveContext ctx) {
        PostgreSQLMoveStatement result = new PostgreSQLMoveStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        if (null != ctx.direction()) {
            result.setDirection((DirectionSegment)this.visit((ParseTree)ctx.direction()));
        }
        return result;
    }

    @Override
    public ASTNode visitClose(PostgreSQLStatementParser.CloseContext ctx) {
        PostgreSQLCloseStatement result = new PostgreSQLCloseStatement();
        if (null != ctx.cursorName()) {
            result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        }
        result.setCloseAll(null != ctx.ALL());
        return result;
    }

    @Override
    public ASTNode visitCursorName(PostgreSQLStatementParser.CursorNameContext ctx) {
        return new CursorNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
    }

    @Override
    public ASTNode visitCluster(PostgreSQLStatementParser.ClusterContext ctx) {
        PostgreSQLClusterStatement result = new PostgreSQLClusterStatement();
        if (null != ctx.tableName()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        }
        if (null != ctx.clusterIndexSpecification()) {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.clusterIndexSpecification().indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateAccessMethod(PostgreSQLStatementParser.CreateAccessMethodContext ctx) {
        return new PostgreSQLCreateAccessMethodStatement();
    }

    @Override
    public ASTNode visitCreateAggregate(PostgreSQLStatementParser.CreateAggregateContext ctx) {
        return new PostgreSQLCreateAggregateStatement();
    }

    @Override
    public ASTNode visitNext(PostgreSQLStatementParser.NextContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.NEXT);
        return result;
    }

    @Override
    public ASTNode visitPrior(PostgreSQLStatementParser.PriorContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.PRIOR);
        return result;
    }

    @Override
    public ASTNode visitFirst(PostgreSQLStatementParser.FirstContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FIRST);
        return result;
    }

    @Override
    public ASTNode visitLast(PostgreSQLStatementParser.LastContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.LAST);
        return result;
    }

    @Override
    public ASTNode visitAbsoluteCount(PostgreSQLStatementParser.AbsoluteCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.ABSOLUTE_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitRelativeCount(PostgreSQLStatementParser.RelativeCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.RELATIVE_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitCount(PostgreSQLStatementParser.CountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitAll(PostgreSQLStatementParser.AllContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.ALL);
        return result;
    }

    @Override
    public ASTNode visitForward(PostgreSQLStatementParser.ForwardContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FORWARD);
        return result;
    }

    @Override
    public ASTNode visitForwardCount(PostgreSQLStatementParser.ForwardCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FORWARD_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitForwardAll(PostgreSQLStatementParser.ForwardAllContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FORWARD_ALL);
        return result;
    }

    @Override
    public ASTNode visitBackward(PostgreSQLStatementParser.BackwardContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.BACKWARD);
        return result;
    }

    @Override
    public ASTNode visitBackwardCount(PostgreSQLStatementParser.BackwardCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.BACKWARD_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitBackwardAll(PostgreSQLStatementParser.BackwardAllContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.BACKWARD_ALL);
        return result;
    }

    @Override
    public ASTNode visitCreateCast(PostgreSQLStatementParser.CreateCastContext ctx) {
        return new PostgreSQLCreateCastStatement();
    }

    @Override
    public ASTNode visitListen(PostgreSQLStatementParser.ListenContext ctx) {
        String channelName = ctx.channelName().getText();
        PostgreSQLListenStatement result = new PostgreSQLListenStatement();
        result.setChannelName(channelName);
        return result;
    }

    @Override
    public ASTNode visitUnlisten(PostgreSQLStatementParser.UnlistenContext ctx) {
        return new PostgreSQLUnlistenStatement();
    }

    @Override
    public ASTNode visitNotifyStmt(PostgreSQLStatementParser.NotifyStmtContext ctx) {
        return new PostgreSQLNotifyStmtStatement();
    }

    @Override
    public ASTNode visitCreateCollation(PostgreSQLStatementParser.CreateCollationContext ctx) {
        return new PostgreSQLCreateCollationStatement();
    }

    @Override
    public ASTNode visitRefreshMatViewStmt(PostgreSQLStatementParser.RefreshMatViewStmtContext ctx) {
        return new PostgreSQLRefreshMatViewStmtStatement();
    }

    @Override
    public ASTNode visitReindex(PostgreSQLStatementParser.ReindexContext ctx) {
        return new PostgreSQLReindexStatement();
    }

    @Override
    public ASTNode visitSecurityLabelStmt(PostgreSQLStatementParser.SecurityLabelStmtContext ctx) {
        return new PostgreSQLSecurityLabelStmtStatement();
    }

    @Override
    public ASTNode visitCreateEventTrigger(PostgreSQLStatementParser.CreateEventTriggerContext ctx) {
        return new PostgreSQLCreateEventTriggerStatement();
    }

    @Override
    public ASTNode visitCreateForeignDataWrapper(PostgreSQLStatementParser.CreateForeignDataWrapperContext ctx) {
        return new PostgreSQLCreateForeignDataWrapperStatement();
    }

    @Override
    public ASTNode visitCreateForeignTable(PostgreSQLStatementParser.CreateForeignTableContext ctx) {
        return new PostgreSQLCreateForeignTableStatement();
    }

    @Override
    public ASTNode visitCreateMaterializedView(PostgreSQLStatementParser.CreateMaterializedViewContext ctx) {
        return new PostgreSQLCreateMaterializedViewStatement();
    }

    @Override
    public ASTNode visitCreateOperator(PostgreSQLStatementParser.CreateOperatorContext ctx) {
        return new PostgreSQLCreateOperatorStatement();
    }

    @Override
    public ASTNode visitCreatePolicy(PostgreSQLStatementParser.CreatePolicyContext ctx) {
        return new PostgreSQLCreatePolicyStatement();
    }

    @Override
    public ASTNode visitCreatePublication(PostgreSQLStatementParser.CreatePublicationContext ctx) {
        return new PostgreSQLCreatePublicationStatement();
    }
}

