/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.Metric;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.common.metrics.ThreadSafeCounter;
import org.apache.seatunnel.api.common.metrics.ThreadSafeQPSMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsContext
implements MetricsContext,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetricsContext.class);
    private static final long serialVersionUID = 1L;
    protected final Map<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();

    @Override
    public Counter counter(String name) {
        if (this.metrics.containsKey(name)) {
            return (Counter)this.metrics.get(name);
        }
        return this.counter(name, new ThreadSafeCounter(name));
    }

    @Override
    public <C extends Counter> C counter(String name, C counter) {
        this.addMetric(name, counter);
        return counter;
    }

    @Override
    public Meter meter(String name) {
        if (this.metrics.containsKey(name)) {
            return (Meter)this.metrics.get(name);
        }
        return this.meter(name, new ThreadSafeQPSMeter(name));
    }

    @Override
    public <M extends Meter> M meter(String name, M meter) {
        this.addMetric(name, meter);
        return meter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetric(String name, Metric metric) {
        if (metric == null) {
            log.warn("Ignoring attempted add of a metric due to being null for name {}.", (Object)name);
        } else {
            AbstractMetricsContext abstractMetricsContext = this;
            synchronized (abstractMetricsContext) {
                Metric prior = this.metrics.put(name, metric);
                if (prior != null) {
                    this.metrics.put(name, prior);
                    log.warn("Name collision: MetricsContext already contains a Metric with the name '" + name + "'. Metric will not be reported.");
                }
            }
        }
    }

    public String toString() {
        return "AbstractMetricsContext{metrics=" + this.metrics + '}';
    }
}

