/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.sqlserver.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.api.utils.JdbcUtils;
import org.apache.seatunnel.datasource.plugin.sqlserver.jdbc.SqlServerDataSourceConfig;
import org.apache.seatunnel.datasource.plugin.sqlserver.jdbc.SqlServerOptionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDataSourceChannel
implements DataSourceChannel {
    private static final Logger log = LoggerFactory.getLogger(SqlServerDataSourceChannel.class);

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return SqlServerDataSourceConfig.OPTION_RULE;
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return SqlServerDataSourceConfig.METADATA_RULE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> options) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        StringBuilder queryWhere = new StringBuilder();
        String query = String.format("SELECT SCHEMA_NAME(schema_id) AS schema_name, name AS table_name\nFROM %s.sys.tables \nWHERE type = 'U' AND is_ms_shipped = 0 \n", database);
        queryWhere.append(query);
        String filterName = options.get("filterName");
        if (StringUtils.isNotEmpty(filterName)) {
            String[] split = filterName.split("\\.");
            if (split.length == 2) {
                String formatStr = " AND (name LIKE '" + (split[1].contains("%") ? split[1] : "%" + split[1] + "%") + "' AND SCHEMA_NAME(schema_id) LIKE '" + (split[0].contains("%") ? split[0] : "%" + split[0] + "%") + "')";
                queryWhere.append(formatStr);
            } else {
                String filterNameRep = filterName.contains("%") ? filterName : "%" + filterName + "%";
                String formatStr = " AND (name LIKE '" + filterNameRep + "' OR SCHEMA_NAME(schema_id) LIKE '" + filterNameRep + "')";
                queryWhere.append(formatStr);
            }
        }
        queryWhere.append("ORDER BY schema_name, table_name");
        String size = options.get("size");
        if (StringUtils.isNotEmpty(size)) {
            queryWhere.append(" OFFSET 0 ROWS FETCH NEXT ").append(size).append(" ROWS ONLY");
        }
        log.info("execute sql :{}", (Object)queryWhere.toString());
        long start = System.currentTimeMillis();
        try (Connection connection = this.getConnection(requestParams);){
            long end = System.currentTimeMillis();
            log.info("connection, cost {}ms for sqlserver", (Object)(end - start));
            start = System.currentTimeMillis();
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(queryWhere.toString());){
                end = System.currentTimeMillis();
                log.info("execute sql, cost {}ms for sqlserver", (Object)(end - start));
                start = System.currentTimeMillis();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("SCHEMA_NAME");
                    String tableName = resultSet.getString("table_name");
                    if (!StringUtils.isNotBlank(schemaName) || SqlServerDataSourceConfig.SQLSERVER_SYSTEM_DATABASES.contains(schemaName)) continue;
                    tableNames.add(schemaName + "." + tableName);
                }
                end = System.currentTimeMillis();
                log.info("while result set, cost {}ms for sqlserver", (Object)(end - start));
            }
            ArrayList<String> arrayList = tableNames;
            return arrayList;
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DataSourcePluginException("get table names failed", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try (Connection ignored = this.getConnection(requestParams);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DataSourcePluginException("check jdbc connectivity failed", (Throwable)e);
        }
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        Pair<String, String> pair = this.parseSchemaAndTable(table);
        return this.getTableFields(requestParams, database, pair.getLeft(), pair.getRight());
    }

    private List<TableField> getTableFields(Map<String, String> requestParams, String dbName, String schemaName, String tableName) {
        ArrayList<TableField> tableFields = new ArrayList<TableField>();
        try (Connection connection = this.getConnection(requestParams);){
            DatabaseMetaData metaData = connection.getMetaData();
            String primaryKey = this.getPrimaryKey(metaData, dbName, schemaName, tableName);
            try (ResultSet resultSet = metaData.getColumns(dbName, schemaName, tableName, null);){
                while (resultSet.next()) {
                    TableField tableField = new TableField();
                    String columnName = resultSet.getString("COLUMN_NAME");
                    tableField.setPrimaryKey(Boolean.valueOf(false));
                    if (StringUtils.isNotBlank(primaryKey) && primaryKey.equals(columnName)) {
                        tableField.setPrimaryKey(Boolean.valueOf(true));
                    }
                    tableField.setName(columnName);
                    String typeString = resultSet.getString("TYPE_NAME");
                    String[] parts = typeString.split(" ");
                    String baseType = parts.length > 0 ? parts[0] : "";
                    tableField.setType(baseType);
                    tableField.setComment(resultSet.getString("REMARKS"));
                    Object nullable = resultSet.getObject("IS_NULLABLE");
                    boolean isNullable = this.convertToBoolean(nullable);
                    tableField.setNullable(Boolean.valueOf(isNullable));
                    tableFields.add(tableField);
                }
            }
        }
        catch (Exception e) {
            throw new DataSourcePluginException("get table fields failed", (Throwable)e);
        }
        return tableFields;
    }

    private boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("TRUE");
        }
        return false;
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        return null;
    }

    private String getPrimaryKey(DatabaseMetaData metaData, String dbName, String schemaName, String tableName) throws SQLException {
        try (ResultSet primaryKeysInfo = metaData.getPrimaryKeys(dbName, schemaName, tableName);){
            if (primaryKeysInfo.next()) {
                String string = primaryKeysInfo.getString("COLUMN_NAME");
                return string;
            }
        }
        return null;
    }

    private Connection getConnection(Map<String, String> requestParams) throws SQLException, ClassNotFoundException {
        return this.getConnection(requestParams, null);
    }

    private Connection getConnection(Map<String, String> requestParams, String databaseName) throws SQLException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)requestParams.get(SqlServerOptionRule.DRIVER.key()));
        Preconditions.checkNotNull((Object)requestParams.get(SqlServerOptionRule.URL.key()), (Object)"Jdbc url cannot be null");
        String url = JdbcUtils.replaceDatabase((String)requestParams.get(SqlServerOptionRule.URL.key()), (String)databaseName);
        if (requestParams.containsKey(SqlServerOptionRule.USER.key())) {
            String username = requestParams.get(SqlServerOptionRule.USER.key());
            String password = requestParams.get(SqlServerOptionRule.PASSWORD.key());
            return DriverManager.getConnection(url, username, password);
        }
        return DriverManager.getConnection(url);
    }

    private Pair<String, String> parseSchemaAndTable(String tableName) {
        String[] schemaAndTable = tableName.split("\\.");
        if (schemaAndTable.length != 2) {
            throw new DataSourcePluginException("table name is invalid");
        }
        return Pair.of(schemaAndTable[0], schemaAndTable[1]);
    }

    public Connection getConnection(String pluginName, Map<String, String> requestParams) {
        try {
            return this.getConnection(requestParams);
        }
        catch (Exception e) {
            throw new DataSourcePluginException("sqlServer get connection failed", (Throwable)e);
        }
    }
}

