/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.mysql.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.api.utils.JdbcUtils;
import org.apache.seatunnel.datasource.plugin.mysql.jdbc.MysqlDataSourceConfig;
import org.apache.seatunnel.datasource.plugin.mysql.jdbc.MysqlOptionRule;

public class MysqlJdbcDataSourceChannel
implements DataSourceChannel {
    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return MysqlDataSourceConfig.OPTION_RULE;
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return MysqlDataSourceConfig.METADATA_RULE;
    }

    /*
     * Exception decompiling
     */
    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try (Connection ignored = this.getConnection(requestParams);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DataSourcePluginException("check jdbc connectivity failed", (Throwable)e);
        }
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        ArrayList<TableField> tableFields = new ArrayList<TableField>();
        if (database == null) {
            throw new NullPointerException("\u5165\u53c2\u5185\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (table == null) {
            throw new NullPointerException("\u5165\u53c2\u5185\u6570\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try (Connection connection = this.getConnection(requestParams, database);){
            PreparedStatement stmt = connection.prepareStatement("SELECT * FROM information_schema.columns WHERE table_schema = ? AND table_name = ? ORDER BY ORDINAL_POSITION ASC");
            stmt.setString(1, database);
            stmt.setString(2, table);
            ResultSet resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                TableField tableField = new TableField();
                tableField.setPrimaryKey(Boolean.valueOf("PRI".equals(resultSet.getString("COLUMN_KEY"))));
                tableField.setName(resultSet.getString("COLUMN_NAME"));
                tableField.setType(resultSet.getString("DATA_TYPE").toUpperCase());
                tableField.setComment(resultSet.getString("COLUMN_COMMENT"));
                tableField.setNullable(Boolean.valueOf("YES".equals(resultSet.getString("IS_NULLABLE"))));
                tableFields.add(tableField);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DataSourcePluginException("get table fields failed", (Throwable)e);
        }
        return tableFields;
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        return tables.parallelStream().collect(Collectors.toMap(Function.identity(), table -> this.getTableFields(pluginName, requestParams, database, (String)table)));
    }

    private String getPrimaryKey(DatabaseMetaData metaData, String dbName, String tableName) throws SQLException {
        ResultSet primaryKeysInfo = metaData.getPrimaryKeys(dbName, "%", tableName);
        if (primaryKeysInfo.next()) {
            return primaryKeysInfo.getString("COLUMN_NAME");
        }
        return null;
    }

    private Connection getConnection(Map<String, String> requestParams) throws SQLException, ClassNotFoundException {
        return this.getConnection(requestParams, null);
    }

    private Connection getConnection(Map<String, String> requestParams, String databaseName) throws SQLException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)requestParams.get(MysqlOptionRule.DRIVER.key()));
        Preconditions.checkNotNull((Object)requestParams.get(MysqlOptionRule.URL.key()), (Object)"Jdbc url cannot be null");
        String url = JdbcUtils.replaceDatabase((String)requestParams.get(MysqlOptionRule.URL.key()), (String)databaseName);
        Properties info = new Properties();
        info.put("autoDeserialize", "false");
        info.put("allowLoadLocalInfile", "false");
        info.put("allowLoadLocalInfileInPath", "");
        if (requestParams.containsKey(MysqlOptionRule.USER.key())) {
            info.put("user", requestParams.get(MysqlOptionRule.USER.key()));
            info.put("password", requestParams.get(MysqlOptionRule.PASSWORD.key()));
        }
        return DriverManager.getConnection(url, info);
    }

    public Connection getConnection(String pluginName, Map<String, String> requestParams) {
        try {
            return this.getConnection(requestParams);
        }
        catch (Exception e) {
            throw new DataSourcePluginException("mysql get connection failed", (Throwable)e);
        }
    }
}

