/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.elasticsearch.ElasticSearchOptionRule;
import org.apache.seatunnel.datasource.plugin.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;

public class ElasticSearchDataSourceChannel
implements DataSourceChannel {
    private static final String DATABASE = "default";

    public boolean canAbleGetSchema() {
        return true;
    }

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return ElasticSearchOptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return ElasticSearchOptionRule.metadataRule();
    }

    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> option) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        ElasticSearchDataSourceChannel.databaseCheck(database);
        try (EsRestClient client = EsRestClient.createInstance(ConfigFactory.parseMap(requestParams));){
            List<String> list = client.listIndex();
            return list;
        }
    }

    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        return DEFAULT_DATABASES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try (EsRestClient client = EsRestClient.createInstance(ConfigFactory.parseMap(requestParams));){
            client.getClusterInfo();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new DataSourcePluginException("check ElasticSearch connectivity failed, " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        ElasticSearchDataSourceChannel.databaseCheck(database);
        try (EsRestClient client = EsRestClient.createInstance(ConfigFactory.parseMap(requestParams));){
            Map<String, String> fieldTypeMapping = client.getFieldTypeMapping(table);
            ArrayList<TableField> fields = new ArrayList<TableField>();
            fieldTypeMapping.forEach((fieldName, fieldType) -> fields.add(this.convertToTableField((String)fieldName, (String)fieldType)));
            ArrayList<TableField> arrayList = fields;
            return arrayList;
        }
        catch (Exception ex) {
            throw new DataSourcePluginException("Get table fields failed", (Throwable)ex);
        }
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        ElasticSearchDataSourceChannel.databaseCheck(database);
        HashMap<String, List<TableField>> tableFields = new HashMap<String, List<TableField>>();
        tables.forEach(table -> tableFields.put((String)table, this.getTableFields(pluginName, requestParams, database, (String)table)));
        return tableFields;
    }

    private static void databaseCheck(@NonNull String database) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (!StringUtils.equalsIgnoreCase(database, DATABASE)) {
            throw new IllegalArgumentException("database not found: " + database);
        }
    }

    private TableField convertToTableField(String fieldName, String fieldType) {
        TableField tableField = new TableField();
        tableField.setName(fieldName);
        tableField.setType(fieldType);
        tableField.setComment(null);
        tableField.setNullable(Boolean.valueOf(true));
        tableField.setPrimaryKey(Boolean.valueOf(fieldName.equals("_id")));
        tableField.setDefaultValue(null);
        return tableField;
    }
}

