/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.source;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSourceTableConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.source.StarRocksSourceReader;
import org.apache.seatunnel.connectors.seatunnel.starrocks.source.StarRocksSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.starrocks.source.StarRocksSourceState;
import org.apache.seatunnel.connectors.seatunnel.starrocks.source.StartRocksSourceSplitEnumerator;

public class StarRocksSource
implements SeaTunnelSource<SeaTunnelRow, StarRocksSourceSplit, StarRocksSourceState> {
    private SourceConfig sourceConfig;

    public String getPluginName() {
        return "StarRocks";
    }

    public StarRocksSource(SourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return this.sourceConfig.getTableConfigList().stream().map(StarRocksSourceTableConfig::getCatalogTable).collect(Collectors.toList());
    }

    public SourceReader createReader(SourceReader.Context readerContext) {
        return new StarRocksSourceReader(readerContext, this.sourceConfig);
    }

    public SourceSplitEnumerator<StarRocksSourceSplit, StarRocksSourceState> restoreEnumerator(SourceSplitEnumerator.Context<StarRocksSourceSplit> enumeratorContext, StarRocksSourceState checkpointState) throws Exception {
        return new StartRocksSourceSplitEnumerator(enumeratorContext, this.sourceConfig, checkpointState);
    }

    public SourceSplitEnumerator createEnumerator(SourceSplitEnumerator.Context enumeratorContext) {
        return new StartRocksSourceSplitEnumerator((SourceSplitEnumerator.Context<StarRocksSourceSplit>)enumeratorContext, this.sourceConfig);
    }
}

