/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.sink;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.sink.SupportSchemaEvolutionSinkWriter;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.schema.handler.TableSchemaChangeEventDispatcher;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.starrocks.client.StarRocksSinkManager;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksCsvSerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksISerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksJsonSerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.util.SchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void>
implements SupportMultiTableSinkWriter<Void>,
SupportSchemaEvolutionSinkWriter {
    private static final Logger log = LoggerFactory.getLogger(StarRocksSinkWriter.class);
    private StarRocksISerializer serializer;
    private StarRocksSinkManager manager;
    private TableSchema tableSchema;
    private final SinkConfig sinkConfig;
    private final TablePath sinkTablePath;
    private final TableSchemaChangeEventDispatcher tableSchemaChangeEventDispatcher = new TableSchemaChangeEventDispatcher();

    public StarRocksSinkWriter(SinkConfig sinkConfig, TableSchema tableSchema, TablePath tablePath) {
        this.tableSchema = tableSchema;
        SeaTunnelRowType seaTunnelRowType = tableSchema.toPhysicalRowDataType();
        this.serializer = this.createSerializer(sinkConfig, seaTunnelRowType);
        this.manager = new StarRocksSinkManager(sinkConfig, tableSchema);
        this.sinkConfig = sinkConfig;
        this.sinkTablePath = tablePath;
    }

    public void write(SeaTunnelRow element) throws IOException {
        String record;
        try {
            record = this.serializer.serialize(element);
        }
        catch (Exception e) {
            throw CommonError.seatunnelRowSerializeFailed((String)element.toString(), (Throwable)e);
        }
        this.manager.write(record);
    }

    public void applySchemaChange(SchemaChangeEvent event) {
        this.tableSchema = this.tableSchemaChangeEventDispatcher.reset(this.tableSchema).apply(event);
        SeaTunnelRowType seaTunnelRowType = this.tableSchema.toPhysicalRowDataType();
        this.serializer = this.createSerializer(this.sinkConfig, seaTunnelRowType);
        this.manager = new StarRocksSinkManager(this.sinkConfig, this.tableSchema);
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load MySQL JDBC driver", e);
        }
        try (Connection conn = DriverManager.getConnection(this.sinkConfig.getJdbcUrl(), this.sinkConfig.getUsername(), this.sinkConfig.getPassword());){
            SchemaUtils.applySchemaChange(event, conn, this.sinkTablePath);
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", this.sinkConfig.getJdbcUrl()), (Throwable)e);
        }
    }

    @Override
    public Optional<Void> prepareCommit() {
        this.manager.flush();
        return super.prepareCommit();
    }

    public void close() throws IOException {
        try {
            if (this.manager != null) {
                this.manager.close();
            }
        }
        catch (IOException e) {
            log.error("Close starRocks manager failed.", (Throwable)e);
            throw CommonError.closeFailed((String)"StarRocks", (Throwable)e);
        }
    }

    public StarRocksISerializer createSerializer(SinkConfig sinkConfig, SeaTunnelRowType seaTunnelRowType) {
        if (SinkConfig.StreamLoadFormat.CSV.equals((Object)sinkConfig.getLoadFormat())) {
            return new StarRocksCsvSerializer(sinkConfig.getColumnSeparator(), seaTunnelRowType, sinkConfig.isEnableUpsertDelete());
        }
        if (SinkConfig.StreamLoadFormat.JSON.equals((Object)sinkConfig.getLoadFormat())) {
            return new StarRocksJsonSerializer(seaTunnelRowType, sinkConfig.isEnableUpsertDelete());
        }
        throw CommonError.illegalArgument((String)sinkConfig.getLoadFormat().name(), (String)"starrocks stream load");
    }
}

