/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.serialize;

import java.io.StringWriter;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.starrocks.exception.StarRocksConnectorException;
import org.apache.seatunnel.shade.com.google.common.base.Strings;

public class StarRocksDelimiterParser {
    private static final int SHIFT = 4;
    private static final String HEX_STRING = "0123456789ABCDEF";

    public static String parse(String sp, String dSp) throws RuntimeException {
        if (Strings.isNullOrEmpty((String)sp)) {
            return dSp;
        }
        if (!sp.toUpperCase().startsWith("\\X")) {
            return sp;
        }
        String hexStr = sp.substring(2);
        if (hexStr.isEmpty()) {
            throw new StarRocksConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Failed to parse delimiter: `Hex str is empty`");
        }
        if (hexStr.length() % 2 != 0) {
            throw new StarRocksConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Failed to parse delimiter: `Hex str is empty`");
        }
        for (char hexChar : hexStr.toUpperCase().toCharArray()) {
            if (HEX_STRING.indexOf(hexChar) != -1) continue;
            throw new StarRocksConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Failed to parse delimiter: `Hex str is empty`");
        }
        StringWriter writer = new StringWriter();
        for (byte b : StarRocksDelimiterParser.hexStrToBytes(hexStr)) {
            writer.append((char)b);
        }
        return writer.toString();
    }

    private static byte[] hexStrToBytes(String hexStr) {
        String upperHexStr = hexStr.toUpperCase();
        int length = upperHexStr.length() / 2;
        char[] hexChars = upperHexStr.toCharArray();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            bytes[i] = (byte)(StarRocksDelimiterParser.charToByte(hexChars[pos]) << 4 | StarRocksDelimiterParser.charToByte(hexChars[pos + 1]));
        }
        return bytes;
    }

    private static byte charToByte(char c) {
        return (byte)HEX_STRING.indexOf(c);
    }
}

