/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.serialize;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.starrocks.exception.StarRocksConnectorException;

public class StarRocksBaseSerializer {
    private DateUtils.Formatter dateFormatter = DateUtils.Formatter.YYYY_MM_DD;
    private DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private TimeUtils.Formatter timeFormatter = TimeUtils.Formatter.HH_MM_SS;

    protected Object convert(SeaTunnelDataType dataType, Object val) {
        if (val == null) {
            return null;
        }
        switch (dataType.getSqlType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case BOOLEAN: 
            case STRING: {
                return val;
            }
            case DATE: {
                return DateUtils.toString((LocalDate)((LocalDate)val), (DateUtils.Formatter)this.dateFormatter);
            }
            case TIME: {
                return TimeUtils.toString((LocalTime)((LocalTime)val), (TimeUtils.Formatter)this.timeFormatter);
            }
            case TIMESTAMP: {
                return ((LocalDateTime)val).format(this.dateTimeFormatter);
            }
            case ARRAY: 
            case MAP: {
                return JsonUtils.toJsonString((Object)val);
            }
            case BYTES: {
                return new String((byte[])val);
            }
        }
        throw new StarRocksConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, dataType + " is not supported ");
    }
}

