/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.ReadonlyConfigParser;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSourceOptions;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;

public class StarRocksSourceTableConfig
implements Serializable {
    private final String table;
    private final CatalogTable catalogTable;
    private final String scanFilter;

    private StarRocksSourceTableConfig(String tableName, CatalogTable catalogTable, String scanFilter) {
        this.table = tableName;
        this.catalogTable = catalogTable;
        this.scanFilter = scanFilter;
    }

    public static StarRocksSourceTableConfig parseStarRocksSourceConfig(ReadonlyConfig config) {
        String table = (String)config.get(StarRocksSourceOptions.TABLE);
        TablePath tablePath = TablePath.of((String)table);
        TableSchema tableSchema = new ReadonlyConfigParser().parse(config);
        CatalogTable catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"", (TablePath)tablePath), (TableSchema)tableSchema, new HashMap(), new ArrayList(), (String)"");
        return new StarRocksSourceTableConfig(table, catalogTable, (String)config.get(StarRocksSourceOptions.SCAN_FILTER));
    }

    public static List<StarRocksSourceTableConfig> of(ReadonlyConfig config) {
        if (config.getOptional(StarRocksSourceOptions.TABLE_LIST).isPresent()) {
            List maps = (List)config.get(StarRocksSourceOptions.TABLE_LIST);
            return maps.stream().map(ReadonlyConfig::fromMap).map(StarRocksSourceTableConfig::parseStarRocksSourceConfig).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new StarRocksSourceTableConfig[]{StarRocksSourceTableConfig.parseStarRocksSourceConfig(config)});
    }

    public String getTable() {
        return this.table;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public String getScanFilter() {
        return this.scanFilter;
    }
}

