/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSinkOptions;

public class SinkConfig
implements Serializable {
    private List<String> nodeUrls;
    private String jdbcUrl;
    private String username;
    private String password;
    private String database;
    private String table;
    private String labelPrefix;
    private String columnSeparator;
    private StreamLoadFormat loadFormat;
    private int batchMaxSize;
    private long batchMaxBytes;
    private int maxRetries;
    private int retryBackoffMultiplierMs;
    private int maxRetryBackoffMs;
    private boolean enableUpsertDelete;
    private String saveModeCreateTemplate;
    private SchemaSaveMode schemaSaveMode;
    private DataSaveMode dataSaveMode;
    private String customSql;
    private int httpSocketTimeout;
    private final Map<String, Object> streamLoadProps = new HashMap<String, Object>();

    public static SinkConfig of(ReadonlyConfig config) {
        SinkConfig sinkConfig = new SinkConfig();
        sinkConfig.setNodeUrls((List)config.get(StarRocksSinkOptions.NODE_URLS));
        sinkConfig.setDatabase((String)config.get(StarRocksSinkOptions.DATABASE));
        sinkConfig.setJdbcUrl((String)config.get(StarRocksSinkOptions.BASE_URL));
        config.getOptional(StarRocksSinkOptions.USERNAME).ifPresent(sinkConfig::setUsername);
        config.getOptional(StarRocksSinkOptions.PASSWORD).ifPresent(sinkConfig::setPassword);
        config.getOptional(StarRocksSinkOptions.TABLE).ifPresent(sinkConfig::setTable);
        config.getOptional(StarRocksSinkOptions.LABEL_PREFIX).ifPresent(sinkConfig::setLabelPrefix);
        sinkConfig.setBatchMaxSize((Integer)config.get(StarRocksSinkOptions.BATCH_MAX_SIZE));
        sinkConfig.setBatchMaxBytes((Long)config.get(StarRocksSinkOptions.BATCH_MAX_BYTES));
        config.getOptional(StarRocksSinkOptions.MAX_RETRIES).ifPresent(sinkConfig::setMaxRetries);
        config.getOptional(StarRocksSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS).ifPresent(sinkConfig::setRetryBackoffMultiplierMs);
        config.getOptional(StarRocksSinkOptions.MAX_RETRY_BACKOFF_MS).ifPresent(sinkConfig::setMaxRetryBackoffMs);
        config.getOptional(StarRocksSinkOptions.ENABLE_UPSERT_DELETE).ifPresent(sinkConfig::setEnableUpsertDelete);
        sinkConfig.setSaveModeCreateTemplate((String)config.get(StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE));
        config.getOptional(StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE).ifPresent(sinkConfig::setSaveModeCreateTemplate);
        config.getOptional(StarRocksSinkOptions.STARROCKS_CONFIG).ifPresent(options -> sinkConfig.getStreamLoadProps().putAll((Map<String, Object>)options));
        config.getOptional(StarRocksSinkOptions.COLUMN_SEPARATOR).ifPresent(sinkConfig::setColumnSeparator);
        sinkConfig.setLoadFormat((StreamLoadFormat)((Object)config.get(StarRocksSinkOptions.LOAD_FORMAT)));
        sinkConfig.setSchemaSaveMode((SchemaSaveMode)config.get(StarRocksSinkOptions.SCHEMA_SAVE_MODE));
        sinkConfig.setDataSaveMode((DataSaveMode)config.get(StarRocksSinkOptions.DATA_SAVE_MODE));
        sinkConfig.setCustomSql((String)config.get(StarRocksSinkOptions.CUSTOM_SQL));
        sinkConfig.setHttpSocketTimeout((Integer)config.get(StarRocksSinkOptions.HTTP_SOCKET_TIMEOUT_MS));
        return sinkConfig;
    }

    public void setNodeUrls(List<String> nodeUrls) {
        this.nodeUrls = nodeUrls;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setLoadFormat(StreamLoadFormat loadFormat) {
        this.loadFormat = loadFormat;
    }

    public void setBatchMaxSize(int batchMaxSize) {
        this.batchMaxSize = batchMaxSize;
    }

    public void setBatchMaxBytes(long batchMaxBytes) {
        this.batchMaxBytes = batchMaxBytes;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryBackoffMultiplierMs(int retryBackoffMultiplierMs) {
        this.retryBackoffMultiplierMs = retryBackoffMultiplierMs;
    }

    public void setMaxRetryBackoffMs(int maxRetryBackoffMs) {
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public void setEnableUpsertDelete(boolean enableUpsertDelete) {
        this.enableUpsertDelete = enableUpsertDelete;
    }

    public void setSaveModeCreateTemplate(String saveModeCreateTemplate) {
        this.saveModeCreateTemplate = saveModeCreateTemplate;
    }

    public void setSchemaSaveMode(SchemaSaveMode schemaSaveMode) {
        this.schemaSaveMode = schemaSaveMode;
    }

    public void setDataSaveMode(DataSaveMode dataSaveMode) {
        this.dataSaveMode = dataSaveMode;
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }

    public void setHttpSocketTimeout(int httpSocketTimeout) {
        this.httpSocketTimeout = httpSocketTimeout;
    }

    public List<String> getNodeUrls() {
        return this.nodeUrls;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public StreamLoadFormat getLoadFormat() {
        return this.loadFormat;
    }

    public int getBatchMaxSize() {
        return this.batchMaxSize;
    }

    public long getBatchMaxBytes() {
        return this.batchMaxBytes;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryBackoffMultiplierMs() {
        return this.retryBackoffMultiplierMs;
    }

    public int getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public boolean isEnableUpsertDelete() {
        return this.enableUpsertDelete;
    }

    public String getSaveModeCreateTemplate() {
        return this.saveModeCreateTemplate;
    }

    public SchemaSaveMode getSchemaSaveMode() {
        return this.schemaSaveMode;
    }

    public DataSaveMode getDataSaveMode() {
        return this.dataSaveMode;
    }

    public String getCustomSql() {
        return this.customSql;
    }

    public int getHttpSocketTimeout() {
        return this.httpSocketTimeout;
    }

    public String toString() {
        return "SinkConfig(nodeUrls=" + this.getNodeUrls() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", labelPrefix=" + this.getLabelPrefix() + ", columnSeparator=" + this.getColumnSeparator() + ", loadFormat=" + (Object)((Object)this.getLoadFormat()) + ", batchMaxSize=" + this.getBatchMaxSize() + ", batchMaxBytes=" + this.getBatchMaxBytes() + ", maxRetries=" + this.getMaxRetries() + ", retryBackoffMultiplierMs=" + this.getRetryBackoffMultiplierMs() + ", maxRetryBackoffMs=" + this.getMaxRetryBackoffMs() + ", enableUpsertDelete=" + this.isEnableUpsertDelete() + ", saveModeCreateTemplate=" + this.getSaveModeCreateTemplate() + ", schemaSaveMode=" + this.getSchemaSaveMode() + ", dataSaveMode=" + this.getDataSaveMode() + ", customSql=" + this.getCustomSql() + ", httpSocketTimeout=" + this.getHttpSocketTimeout() + ", streamLoadProps=" + this.getStreamLoadProps() + ")";
    }

    public Map<String, Object> getStreamLoadProps() {
        return this.streamLoadProps;
    }

    public static enum StreamLoadFormat {
        CSV,
        JSON;

    }
}

