/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.sink.writer;

import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBuffer {
    private static final Logger log = LoggerFactory.getLogger(RecordBuffer.class);
    private String fileName;
    private StringJoiner buffer;
    private String lineDelimiter;
    private int numOfRecords = 0;
    private long bufferSizeBytes = 0L;

    public RecordBuffer() {
    }

    public RecordBuffer(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
        this.buffer = new StringJoiner(lineDelimiter);
    }

    public void insert(String record) {
        this.buffer.add(record);
        this.setNumOfRecords(this.getNumOfRecords() + 1);
        this.setBufferSizeBytes(this.getBufferSizeBytes() + (long)record.getBytes(StandardCharsets.UTF_8).length);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isEmpty() {
        return this.numOfRecords == 0;
    }

    public String getData() {
        String result = this.buffer.toString();
        log.debug("flush buffer: {} records, {} bytes", (Object)this.getNumOfRecords(), (Object)this.getBufferSizeBytes());
        return result;
    }

    public int getNumOfRecords() {
        return this.numOfRecords;
    }

    public long getBufferSizeBytes() {
        return this.bufferSizeBytes;
    }

    public void setNumOfRecords(int numOfRecords) {
        this.numOfRecords = numOfRecords;
    }

    public void setBufferSizeBytes(long bufferSizeBytes) {
        this.bufferSizeBytes = bufferSizeBytes;
    }
}

