/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.sink;

import java.util.Optional;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3FileSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sink.BaseMultipleTableFileSink;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class S3FileSink
extends BaseMultipleTableFileSink
implements SupportSaveMode {
    private final CatalogTable catalogTable;
    private final ReadonlyConfig readonlyConfig;
    private static final String S3 = "S3";

    @Override
    public String getPluginName() {
        return FileSystemType.S3.getFileSystemPluginName();
    }

    public S3FileSink(CatalogTable catalogTable, ReadonlyConfig readonlyConfig) {
        super(S3HadoopConf.buildWithReadOnlyConfig(readonlyConfig), readonlyConfig, catalogTable);
        this.catalogTable = catalogTable;
        this.readonlyConfig = readonlyConfig;
        Config pluginConfig = readonlyConfig.toConfig();
        CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{S3FileSinkOptions.FILE_PATH.key(), S3FileSinkOptions.S3_BUCKET.key()});
        if (!result.isSuccess()) {
            throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, result.getMsg()));
        }
    }

    @Override
    public Optional<SaveModeHandler> getSaveModeHandler() {
        CatalogFactory catalogFactory = (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), CatalogFactory.class, (String)S3);
        if (catalogFactory == null) {
            return Optional.empty();
        }
        Catalog catalog = catalogFactory.createCatalog(S3, this.readonlyConfig);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)this.readonlyConfig.get(FileBaseSinkOptions.SCHEMA_SAVE_MODE);
        DataSaveMode dataSaveMode = (DataSaveMode)this.readonlyConfig.get(FileBaseSinkOptions.DATA_SAVE_MODE);
        return Optional.of(new DefaultSaveModeHandler(schemaSaveMode, dataSaveMode, catalog, this.catalogTable, null));
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }
}

