/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3FileBaseOptions;

public class S3HadoopConf
extends HadoopConf {
    private static final String HDFS_S3N_IMPL = "org.apache.hadoop.fs.s3native.NativeS3FileSystem";
    private static final String HDFS_S3A_IMPL = "org.apache.hadoop.fs.s3a.S3AFileSystem";
    protected static final String S3A_SCHEMA = "s3a";
    protected static final String DEFAULT_SCHEMA = "s3n";
    private String schema = "s3n";

    @Override
    public String getFsHdfsImpl() {
        return this.switchHdfsImpl();
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public S3HadoopConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    public static HadoopConf buildWithReadOnlyConfig(ReadonlyConfig config) {
        String bucketName = (String)config.get(S3FileBaseOptions.S3_BUCKET);
        S3HadoopConf hadoopConf = new S3HadoopConf(bucketName);
        if (bucketName.startsWith(S3A_SCHEMA)) {
            hadoopConf.setSchema(S3A_SCHEMA);
        }
        HashMap<String, String> s3Options = new HashMap<String, String>();
        hadoopConf.putS3SK(s3Options, config);
        if (config.getOptional(S3FileBaseOptions.S3_PROPERTIES).isPresent()) {
            ((Map)config.get(S3FileBaseOptions.S3_PROPERTIES)).forEach((key, value) -> s3Options.put((String)key, String.valueOf(value)));
        }
        s3Options.put(S3FileBaseOptions.S3A_AWS_CREDENTIALS_PROVIDER.key(), ((S3FileBaseOptions.S3aAwsCredentialsProvider)((Object)config.get(S3FileBaseOptions.S3A_AWS_CREDENTIALS_PROVIDER))).getProvider());
        s3Options.put(S3FileBaseOptions.FS_S3A_ENDPOINT.key(), (String)config.get(S3FileBaseOptions.FS_S3A_ENDPOINT));
        hadoopConf.setExtraOptions(s3Options);
        return hadoopConf;
    }

    protected String switchHdfsImpl() {
        switch (this.schema) {
            case "s3a": {
                return HDFS_S3A_IMPL;
            }
        }
        return HDFS_S3N_IMPL;
    }

    private void putS3SK(Map<String, String> s3Options, ReadonlyConfig config) {
        if (!config.getOptional(S3FileBaseOptions.S3_ACCESS_KEY).isPresent() && !config.getOptional(S3FileBaseOptions.S3_SECRET_KEY).isPresent()) {
            return;
        }
        String accessKey = (String)config.get(S3FileBaseOptions.S3_ACCESS_KEY);
        String secretKey = (String)config.get(S3FileBaseOptions.S3_SECRET_KEY);
        if (S3A_SCHEMA.equals(this.schema)) {
            s3Options.put("fs.s3a.access.key", accessKey);
            s3Options.put("fs.s3a.secret.key", secretKey);
            return;
        }
        s3Options.put("fs.s3n.awsAccessKeyId", accessKey);
        s3Options.put("fs.s3n.awsSecretAccessKey", secretKey);
    }
}

