/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.source.arrow.converter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.seatunnel.connectors.seatunnel.common.source.arrow.converter.Converter;
import org.apache.seatunnel.shade.org.apache.arrow.vector.complex.MapVector;
import org.apache.seatunnel.shade.org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.seatunnel.shade.org.apache.arrow.vector.types.Types;

public class MapConverter
implements Converter<MapVector> {
    @Override
    public Object convert(int rowIndex, MapVector fieldVector) {
        return fieldVector.isNull(rowIndex) ? null : fieldVector.getObject(rowIndex);
    }

    @Override
    public Object convert(int rowIndex, MapVector fieldVector, Map<String, Function> genericsConverters) {
        UnionMapReader reader = fieldVector.getReader();
        reader.setPosition(rowIndex);
        HashMap mapValue = new HashMap();
        Function keyConverter = genericsConverters.get("KEY");
        Function valueConverter = genericsConverters.get("VALUE");
        while (reader.next()) {
            Object key = keyConverter.apply(this.processTimeZone(reader.key().readObject()));
            Object value = valueConverter.apply(this.processTimeZone(reader.value().readObject()));
            mapValue.put(key, value);
        }
        return mapValue;
    }

    private Object processTimeZone(Object value) {
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        return value;
    }

    @Override
    public boolean support(Types.MinorType type) {
        return Types.MinorType.MAP == type;
    }
}

