/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.srvutil;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class AclFileWatchService
extends ServiceThread {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");
    private final String aclPath;
    private int aclFilesNum;
    @Deprecated
    private final Map<String, String> fileCurrentHash;
    private Map<String, Long> fileLastModifiedTime;
    private List<String> fileList = new ArrayList<String>();
    private final Listener listener;
    private static final int WATCH_INTERVAL = 5000;
    private MessageDigest md = MessageDigest.getInstance("MD5");
    private String defaultAclFile;

    public AclFileWatchService(String path, String defaultAclFile, Listener listener) throws Exception {
        this.aclPath = path;
        this.defaultAclFile = defaultAclFile;
        this.fileCurrentHash = new HashMap<String, String>();
        this.fileLastModifiedTime = new HashMap<String, Long>();
        this.listener = listener;
        this.getAllAclFiles(path);
        if (new File(this.defaultAclFile).exists() && !this.fileList.contains(this.defaultAclFile)) {
            this.fileList.add(this.defaultAclFile);
        }
        this.aclFilesNum = this.fileList.size();
        for (int i = 0; i < this.aclFilesNum; ++i) {
            String fileAbsolutePath = this.fileList.get(i);
            this.fileLastModifiedTime.put(fileAbsolutePath, new File(fileAbsolutePath).lastModified());
        }
    }

    public void getAllAclFiles(String path) {
        File file = new File(path);
        if (!file.exists()) {
            log.info("The default acl dir {} is not exist", (Object)path);
            return;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getAbsolutePath();
            File f = new File(fileName);
            if (fileName.equals(this.aclPath + File.separator + "tools.yml")) continue;
            if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
                this.fileList.add(fileName);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.getAllAclFiles(fileName);
        }
    }

    @Override
    public String getServiceName() {
        return "AclFileWatchService";
    }

    @Override
    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                int realAclFilesNum;
                this.waitForRunning(5000L);
                if (this.fileList.size() > 0) {
                    this.fileList.clear();
                }
                this.getAllAclFiles(this.aclPath);
                if (new File(this.defaultAclFile).exists() && !this.fileList.contains(this.defaultAclFile)) {
                    this.fileList.add(this.defaultAclFile);
                }
                if (this.aclFilesNum != (realAclFilesNum = this.fileList.size())) {
                    log.info("aclFilesNum: " + this.aclFilesNum + "  realAclFilesNum: " + realAclFilesNum);
                    this.aclFilesNum = realAclFilesNum;
                    log.info("aclFilesNum: " + this.aclFilesNum + "  realAclFilesNum: " + realAclFilesNum);
                    HashMap<String, Long> fileLastModifiedTime = new HashMap<String, Long>(realAclFilesNum);
                    for (int i = 0; i < realAclFilesNum; ++i) {
                        String fileAbsolutePath = this.fileList.get(i);
                        fileLastModifiedTime.put(fileAbsolutePath, new File(fileAbsolutePath).lastModified());
                    }
                    this.fileLastModifiedTime = fileLastModifiedTime;
                    this.listener.onFileNumChanged(this.aclPath);
                    continue;
                }
                for (int i = 0; i < this.aclFilesNum; ++i) {
                    String fileName = this.fileList.get(i);
                    Long newLastModifiedTime = new File(fileName).lastModified();
                    if (newLastModifiedTime.equals(this.fileLastModifiedTime.get(fileName))) continue;
                    this.fileLastModifiedTime.put(fileName, newLastModifiedTime);
                    this.listener.onFileChanged(fileName);
                }
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    @Deprecated
    private String hash(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        this.md.update(Files.readAllBytes(path));
        byte[] hash = this.md.digest();
        return UtilAll.bytes2string(hash);
    }

    public static interface Listener {
        public void onFileChanged(String var1);

        public void onFileNumChanged(String var1);
    }
}

