/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.protocol.header;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.annotation.CFNullable;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.FastCodesHeader;

public class PullMessageRequestHeader
implements CommandCustomHeader,
FastCodesHeader {
    @CFNotNull
    private String consumerGroup;
    @CFNotNull
    private String topic;
    @CFNotNull
    private Integer queueId;
    @CFNotNull
    private Long queueOffset;
    @CFNotNull
    private Integer maxMsgNums;
    @CFNotNull
    private Integer sysFlag;
    @CFNotNull
    private Long commitOffset;
    @CFNotNull
    private Long suspendTimeoutMillis;
    @CFNullable
    private String subscription;
    @CFNotNull
    private Long subVersion;
    private String expressionType;

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    @Override
    public void encode(ByteBuf out) {
        this.writeIfNotNull(out, "consumerGroup", this.consumerGroup);
        this.writeIfNotNull(out, "topic", this.topic);
        this.writeIfNotNull(out, "queueId", this.queueId);
        this.writeIfNotNull(out, "queueOffset", this.queueOffset);
        this.writeIfNotNull(out, "maxMsgNums", this.maxMsgNums);
        this.writeIfNotNull(out, "sysFlag", this.sysFlag);
        this.writeIfNotNull(out, "commitOffset", this.commitOffset);
        this.writeIfNotNull(out, "suspendTimeoutMillis", this.suspendTimeoutMillis);
        this.writeIfNotNull(out, "subscription", this.subscription);
        this.writeIfNotNull(out, "subVersion", this.subVersion);
        this.writeIfNotNull(out, "expressionType", this.expressionType);
    }

    @Override
    public void decode(HashMap<String, String> fields) throws RemotingCommandException {
        String str = this.getAndCheckNotNull(fields, "consumerGroup");
        if (str != null) {
            this.consumerGroup = str;
        }
        if ((str = this.getAndCheckNotNull(fields, "topic")) != null) {
            this.topic = str;
        }
        if ((str = this.getAndCheckNotNull(fields, "queueId")) != null) {
            this.queueId = Integer.parseInt(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "queueOffset")) != null) {
            this.queueOffset = Long.parseLong(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "maxMsgNums")) != null) {
            this.maxMsgNums = Integer.parseInt(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "sysFlag")) != null) {
            this.sysFlag = Integer.parseInt(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "commitOffset")) != null) {
            this.commitOffset = Long.parseLong(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "suspendTimeoutMillis")) != null) {
            this.suspendTimeoutMillis = Long.parseLong(str);
        }
        if ((str = fields.get("subscription")) != null) {
            this.subscription = str;
        }
        if ((str = this.getAndCheckNotNull(fields, "subVersion")) != null) {
            this.subVersion = Long.parseLong(str);
        }
        if ((str = fields.get("expressionType")) != null) {
            this.expressionType = str;
        }
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Integer getQueueId() {
        return this.queueId;
    }

    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public Long getQueueOffset() {
        return this.queueOffset;
    }

    public void setQueueOffset(Long queueOffset) {
        this.queueOffset = queueOffset;
    }

    public Integer getMaxMsgNums() {
        return this.maxMsgNums;
    }

    public void setMaxMsgNums(Integer maxMsgNums) {
        this.maxMsgNums = maxMsgNums;
    }

    public Integer getSysFlag() {
        return this.sysFlag;
    }

    public void setSysFlag(Integer sysFlag) {
        this.sysFlag = sysFlag;
    }

    public Long getCommitOffset() {
        return this.commitOffset;
    }

    public void setCommitOffset(Long commitOffset) {
        this.commitOffset = commitOffset;
    }

    public Long getSuspendTimeoutMillis() {
        return this.suspendTimeoutMillis;
    }

    public void setSuspendTimeoutMillis(Long suspendTimeoutMillis) {
        this.suspendTimeoutMillis = suspendTimeoutMillis;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public Long getSubVersion() {
        return this.subVersion;
    }

    public void setSubVersion(Long subVersion) {
        this.subVersion = subVersion;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }
}

