/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqSourceOptions;

public class RabbitmqConfig
implements Serializable {
    private String host;
    private Integer port;
    private String virtualHost;
    private String username;
    private String password;
    private String uri;
    private Integer networkRecoveryInterval;
    private Boolean automaticRecovery;
    private Boolean topologyRecovery;
    private Integer connectionTimeout;
    private Integer requestedChannelMax;
    private Integer requestedFrameMax;
    private Integer requestedHeartbeat;
    private Integer prefetchCount;
    private long deliveryTimeout;
    private String queueName;
    private Boolean durable;
    private Boolean exclusive;
    private Boolean autoDelete;
    private String routingKey;
    private boolean logFailuresOnly = false;
    private String exchange = "";
    private boolean forE2ETesting = false;
    private boolean usesCorrelationId = false;
    private Map<String, String> sinkOptionProps = new HashMap<String, String>();

    public RabbitmqConfig(ReadonlyConfig config) {
        this.host = (String)config.get(RabbitmqBaseOptions.HOST);
        this.port = (Integer)config.get(RabbitmqBaseOptions.PORT);
        this.queueName = (String)config.get(RabbitmqBaseOptions.QUEUE_NAME);
        if (config.getOptional(RabbitmqBaseOptions.USERNAME).isPresent()) {
            this.username = (String)config.get(RabbitmqBaseOptions.USERNAME);
        }
        if (config.getOptional(RabbitmqBaseOptions.PASSWORD).isPresent()) {
            this.password = (String)config.get(RabbitmqBaseOptions.PASSWORD);
        }
        if (config.getOptional(RabbitmqBaseOptions.VIRTUAL_HOST).isPresent()) {
            this.virtualHost = (String)config.get(RabbitmqBaseOptions.VIRTUAL_HOST);
        }
        if (config.getOptional(RabbitmqBaseOptions.NETWORK_RECOVERY_INTERVAL).isPresent()) {
            this.networkRecoveryInterval = (Integer)config.get(RabbitmqBaseOptions.NETWORK_RECOVERY_INTERVAL);
        }
        if (config.getOptional(RabbitmqBaseOptions.AUTOMATIC_RECOVERY_ENABLED).isPresent()) {
            this.automaticRecovery = (Boolean)config.get(RabbitmqBaseOptions.AUTOMATIC_RECOVERY_ENABLED);
        }
        if (config.getOptional(RabbitmqBaseOptions.TOPOLOGY_RECOVERY_ENABLED).isPresent()) {
            this.topologyRecovery = (Boolean)config.get(RabbitmqBaseOptions.TOPOLOGY_RECOVERY_ENABLED);
        }
        if (config.getOptional(RabbitmqBaseOptions.CONNECTION_TIMEOUT).isPresent()) {
            this.connectionTimeout = (Integer)config.get(RabbitmqBaseOptions.CONNECTION_TIMEOUT);
        }
        if (config.getOptional(RabbitmqSourceOptions.REQUESTED_CHANNEL_MAX).isPresent()) {
            this.requestedChannelMax = (Integer)config.get(RabbitmqSourceOptions.REQUESTED_CHANNEL_MAX);
        }
        if (config.getOptional(RabbitmqSourceOptions.REQUESTED_FRAME_MAX).isPresent()) {
            this.requestedFrameMax = (Integer)config.get(RabbitmqSourceOptions.REQUESTED_FRAME_MAX);
        }
        if (config.getOptional(RabbitmqSourceOptions.REQUESTED_HEARTBEAT).isPresent()) {
            this.requestedHeartbeat = (Integer)config.get(RabbitmqSourceOptions.REQUESTED_HEARTBEAT);
        }
        if (config.getOptional(RabbitmqSourceOptions.PREFETCH_COUNT).isPresent()) {
            this.prefetchCount = (Integer)config.get(RabbitmqSourceOptions.PREFETCH_COUNT);
        }
        if (config.getOptional(RabbitmqSourceOptions.DELIVERY_TIMEOUT).isPresent()) {
            this.deliveryTimeout = ((Integer)config.get(RabbitmqSourceOptions.DELIVERY_TIMEOUT)).intValue();
        }
        if (config.getOptional(RabbitmqBaseOptions.ROUTING_KEY).isPresent()) {
            this.routingKey = (String)config.get(RabbitmqBaseOptions.ROUTING_KEY);
        }
        if (config.getOptional(RabbitmqBaseOptions.EXCHANGE).isPresent()) {
            this.exchange = (String)config.get(RabbitmqBaseOptions.EXCHANGE);
        }
        if (config.getOptional(RabbitmqBaseOptions.FOR_E2E_TESTING).isPresent()) {
            this.forE2ETesting = (Boolean)config.get(RabbitmqBaseOptions.FOR_E2E_TESTING);
        }
        if (config.getOptional(RabbitmqSourceOptions.USE_CORRELATION_ID).isPresent()) {
            this.usesCorrelationId = (Boolean)config.get(RabbitmqSourceOptions.USE_CORRELATION_ID);
        }
        this.durable = (Boolean)config.get(RabbitmqBaseOptions.DURABLE);
        this.exclusive = (Boolean)config.get(RabbitmqBaseOptions.EXCLUSIVE);
        this.autoDelete = (Boolean)config.get(RabbitmqBaseOptions.AUTO_DELETE);
        this.sinkOptionProps = (Map)config.get(RabbitmqSinkOptions.RABBITMQ_CONFIG);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setNetworkRecoveryInterval(Integer networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public void setAutomaticRecovery(Boolean automaticRecovery) {
        this.automaticRecovery = automaticRecovery;
    }

    public void setTopologyRecovery(Boolean topologyRecovery) {
        this.topologyRecovery = topologyRecovery;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setRequestedChannelMax(Integer requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public void setRequestedFrameMax(Integer requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public void setRequestedHeartbeat(Integer requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public void setPrefetchCount(Integer prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setDeliveryTimeout(long deliveryTimeout) {
        this.deliveryTimeout = deliveryTimeout;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setLogFailuresOnly(boolean logFailuresOnly) {
        this.logFailuresOnly = logFailuresOnly;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setForE2ETesting(boolean forE2ETesting) {
        this.forE2ETesting = forE2ETesting;
    }

    public void setUsesCorrelationId(boolean usesCorrelationId) {
        this.usesCorrelationId = usesCorrelationId;
    }

    public void setSinkOptionProps(Map<String, String> sinkOptionProps) {
        this.sinkOptionProps = sinkOptionProps;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public Boolean getAutomaticRecovery() {
        return this.automaticRecovery;
    }

    public Boolean getTopologyRecovery() {
        return this.topologyRecovery;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public Integer getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public Integer getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public Integer getPrefetchCount() {
        return this.prefetchCount;
    }

    public long getDeliveryTimeout() {
        return this.deliveryTimeout;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Boolean getDurable() {
        return this.durable;
    }

    public Boolean getExclusive() {
        return this.exclusive;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public boolean isLogFailuresOnly() {
        return this.logFailuresOnly;
    }

    public String getExchange() {
        return this.exchange;
    }

    public boolean isForE2ETesting() {
        return this.forE2ETesting;
    }

    public boolean isUsesCorrelationId() {
        return this.usesCorrelationId;
    }

    public Map<String, String> getSinkOptionProps() {
        return this.sinkOptionProps;
    }

    public RabbitmqConfig() {
    }

    public RabbitmqConfig(String host, Integer port, String virtualHost, String username, String password, String uri, Integer networkRecoveryInterval, Boolean automaticRecovery, Boolean topologyRecovery, Integer connectionTimeout, Integer requestedChannelMax, Integer requestedFrameMax, Integer requestedHeartbeat, Integer prefetchCount, long deliveryTimeout, String queueName, Boolean durable, Boolean exclusive, Boolean autoDelete, String routingKey, boolean logFailuresOnly, String exchange, boolean forE2ETesting, boolean usesCorrelationId, Map<String, String> sinkOptionProps) {
        this.host = host;
        this.port = port;
        this.virtualHost = virtualHost;
        this.username = username;
        this.password = password;
        this.uri = uri;
        this.networkRecoveryInterval = networkRecoveryInterval;
        this.automaticRecovery = automaticRecovery;
        this.topologyRecovery = topologyRecovery;
        this.connectionTimeout = connectionTimeout;
        this.requestedChannelMax = requestedChannelMax;
        this.requestedFrameMax = requestedFrameMax;
        this.requestedHeartbeat = requestedHeartbeat;
        this.prefetchCount = prefetchCount;
        this.deliveryTimeout = deliveryTimeout;
        this.queueName = queueName;
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.routingKey = routingKey;
        this.logFailuresOnly = logFailuresOnly;
        this.exchange = exchange;
        this.forE2ETesting = forE2ETesting;
        this.usesCorrelationId = usesCorrelationId;
        this.sinkOptionProps = sinkOptionProps;
    }
}

