/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.reader;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.seatunnel.common.Handover;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarConfigUtil;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarConsumerConfig;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorException;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start.StartCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.stop.StopCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.reader.PulsarSourceReader;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.reader.RecordWithSplitId;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.split.PulsarPartitionSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSplitReaderThread
extends Thread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSplitReaderThread.class);
    protected final PulsarSourceReader sourceReader;
    protected final PulsarPartitionSplit split;
    protected final PulsarClient pulsarClient;
    protected final PulsarConsumerConfig consumerConfig;
    protected final int pollTimeout;
    protected final long pollInterval;
    protected final StartCursor startCursor;
    protected final Handover<RecordWithSplitId> handover;
    protected Consumer<byte[]> consumer;
    private volatile boolean running;

    public PulsarSplitReaderThread(PulsarSourceReader sourceReader, PulsarPartitionSplit split, PulsarClient pulsarClient, PulsarConsumerConfig consumerConfig, int pollTimeout, long pollInterval, StartCursor startCursor, Handover<RecordWithSplitId> handover) {
        this.sourceReader = sourceReader;
        this.split = split;
        this.pulsarClient = pulsarClient;
        this.consumerConfig = consumerConfig;
        this.pollTimeout = pollTimeout;
        this.pollInterval = pollInterval;
        this.startCursor = startCursor;
        this.handover = handover;
    }

    public void open() throws PulsarClientException {
        this.consumer = this.createPulsarConsumer(this.split);
        if (this.split.getLatestConsumedId() == null) {
            this.startCursor.seekPosition(this.consumer);
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            StopCursor stopCursor = this.split.getStopCursor();
            while (this.running) {
                Message<byte[]> message = this.consumer.receive(this.pollTimeout, TimeUnit.MILLISECONDS);
                if (message != null) {
                    this.handover.produce((Object)new RecordWithSplitId(message, this.split.splitId()));
                    if (!stopCursor.shouldStop(message)) continue;
                    this.sourceReader.handleNoMoreElements(this.split.splitId(), message.getMessageId());
                    break;
                }
                Thread.sleep(this.pollInterval);
            }
        }
        catch (Throwable t) {
            LOG.error("Pulsar Consumer receive data error", t);
            this.handover.reportError(t);
        }
        finally {
            try {
                this.consumer.close();
            }
            catch (Throwable t) {
                LOG.warn("Error while closing pulsar consumer", t);
            }
            finally {
                this.running = false;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public void committingCursor(MessageId offsetsToCommit) throws PulsarClientException {
        if (this.consumer == null) {
            this.consumer = this.createPulsarConsumer(this.split);
        }
        this.consumer.acknowledgeCumulative(offsetsToCommit);
    }

    protected Consumer<byte[]> createPulsarConsumer(PulsarPartitionSplit split) {
        ConsumerBuilder<byte[]> consumerBuilder = PulsarConfigUtil.createConsumerBuilder(this.pulsarClient, this.consumerConfig);
        consumerBuilder.topic(split.getPartition().getFullTopicName());
        try {
            return consumerBuilder.subscribe();
        }
        catch (PulsarClientException e) {
            throw new PulsarConnectorException(PulsarConnectorErrorCode.OPEN_PULSAR_ADMIN_FAILED, "Failed to create pulsar consumer:", e);
        }
    }
}

