/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.PulsarSource;

@AutoService(value={Factory.class})
public class PulsarSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Pulsar";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{PulsarSourceOptions.SUBSCRIPTION_NAME, PulsarSourceOptions.CLIENT_SERVICE_URL, PulsarSourceOptions.ADMIN_SERVICE_URL}).optional(new Option[]{PulsarSourceOptions.CURSOR_STARTUP_MODE, PulsarSourceOptions.CURSOR_STOP_MODE, PulsarSourceOptions.TOPIC_DISCOVERY_INTERVAL, PulsarSourceOptions.POLL_TIMEOUT, PulsarSourceOptions.POLL_INTERVAL, PulsarSourceOptions.POLL_BATCH_SIZE, PulsarSourceOptions.FORMAT, PulsarSourceOptions.SCHEMA}).exclusive(new Option[]{PulsarSourceOptions.TOPIC, PulsarSourceOptions.TOPIC_PATTERN}).conditional(PulsarSourceOptions.FORMAT, (Object)"text", new Option[]{PulsarSourceOptions.FIELD_DELIMITER}).conditional(PulsarSourceOptions.CURSOR_STARTUP_MODE, (Object)PulsarSourceOptions.StartMode.TIMESTAMP, new Option[]{PulsarSourceOptions.CURSOR_STARTUP_TIMESTAMP}).conditional(PulsarSourceOptions.CURSOR_STARTUP_MODE, (Object)PulsarSourceOptions.StartMode.SUBSCRIPTION, new Option[]{PulsarSourceOptions.CURSOR_RESET_MODE}).conditional(PulsarSourceOptions.CURSOR_STOP_MODE, (Object)PulsarSourceOptions.StopMode.TIMESTAMP, new Option[]{PulsarSourceOptions.CURSOR_STOP_TIMESTAMP}).bundled(new Option[]{PulsarSourceOptions.AUTH_PLUGIN_CLASS, PulsarSourceOptions.AUTH_PARAMS}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return PulsarSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        CatalogTable catalogTable = context.getOptions().getOptional(PulsarSourceOptions.SCHEMA).isPresent() ? CatalogTableUtil.buildWithConfig((ReadonlyConfig)context.getOptions()) : CatalogTableUtil.buildSimpleTextTable();
        return () -> new PulsarSource(context.getOptions(), catalogTable);
    }
}

