/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.config;

import java.io.Serializable;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class PulsarConsumerConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String subscriptionName;

    private PulsarConsumerConfig(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String subscriptionName;

        private Builder() {
        }

        public Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public PulsarConsumerConfig build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.subscriptionName), "Pulsar subscription name is required.");
            return new PulsarConsumerConfig(this.subscriptionName);
        }
    }
}

