/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.config;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.BasePulsarConfig;

public class PulsarAdminConfig
extends BasePulsarConfig {
    private static final long serialVersionUID = 1L;
    private final String adminUrl;

    private PulsarAdminConfig(String authPluginClassName, String authParams, String adminUrl) {
        super(authPluginClassName, authParams);
        this.adminUrl = adminUrl;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String authPluginClassName = "";
        private String authParams = "";
        private String adminUrl;

        private Builder() {
        }

        public Builder authPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
            return this;
        }

        public Builder authParams(String authParams) {
            this.authParams = authParams;
            return this;
        }

        public Builder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarAdminConfig build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.adminUrl), "Pulsar admin URL is required.");
            return new PulsarAdminConfig(this.authPluginClassName, this.authParams, this.adminUrl);
        }
    }
}

