/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;

public class RestException
extends WebApplicationException {
    public static String getExceptionData(Throwable t) {
        StringWriter writer = new StringWriter();
        writer.append("\n --- An unexpected error occurred in the server ---\n\n");
        if (t != null) {
            writer.append("Message: ").append(t.getMessage()).append("\n\n");
        }
        writer.append("Stacktrace:\n\n");
        if (t != null) {
            t.printStackTrace(new PrintWriter(writer));
        }
        return writer.toString();
    }

    public RestException(Response.Status status, String message) {
        this(status.getStatusCode(), message);
    }

    public RestException(int code, String message) {
        super(message, Response.status(code).entity(new ErrorData(message)).type("application/json").build());
    }

    public RestException(Throwable t) {
        super(RestException.getResponse(t));
    }

    private static Response getResponse(Throwable t) {
        if (t instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)t;
            return e.getResponse();
        }
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(RestException.getExceptionData(t)).type("text/plain").build();
    }
}

