/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.config;

import java.io.Serializable;
import java.net.URI;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.DriverBuilder;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.neo4j.exception.Neo4jConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.neo4j.driver.AuthTokens;

public abstract class Neo4jQueryInfo
implements Serializable {
    protected DriverBuilder driverBuilder;
    protected String query;
    protected PluginType pluginType;

    public Neo4jQueryInfo(Config config, PluginType pluginType) {
        this.pluginType = pluginType;
        this.driverBuilder = this.prepareDriver(config, pluginType);
        this.query = this.prepareQuery(config, pluginType);
    }

    protected DriverBuilder prepareDriver(Config config, PluginType pluginType) {
        CheckResult uriConfigCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jBaseOptions.KEY_NEO4J_URI.key(), Neo4jBaseOptions.KEY_DATABASE.key()});
        CheckResult authConfigCheck = CheckConfigUtil.checkAtLeastOneExists((Config)config, (String[])new String[]{Neo4jBaseOptions.KEY_USERNAME.key(), Neo4jBaseOptions.KEY_BEARER_TOKEN.key(), Neo4jBaseOptions.KEY_KERBEROS_TICKET.key()});
        CheckResult mergedConfigCheck = CheckConfigUtil.mergeCheckResults((CheckResult[])new CheckResult[]{uriConfigCheck, authConfigCheck});
        if (!mergedConfigCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", pluginType, mergedConfigCheck.getMsg()));
        }
        URI uri = URI.create(config.getString(Neo4jBaseOptions.KEY_NEO4J_URI.key()));
        DriverBuilder driverBuilder = DriverBuilder.create(uri);
        if (config.hasPath(Neo4jBaseOptions.KEY_USERNAME.key())) {
            CheckResult pwParamCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jBaseOptions.KEY_PASSWORD.key()});
            if (!pwParamCheck.isSuccess()) {
                throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", pluginType, pwParamCheck.getMsg()));
            }
            String username = config.getString(Neo4jBaseOptions.KEY_USERNAME.key());
            String password = config.getString(Neo4jBaseOptions.KEY_PASSWORD.key());
            driverBuilder.setUsername(username);
            driverBuilder.setPassword(password);
        } else if (config.hasPath(Neo4jBaseOptions.KEY_BEARER_TOKEN.key())) {
            String bearerToken = config.getString(Neo4jBaseOptions.KEY_BEARER_TOKEN.key());
            AuthTokens.bearer(bearerToken);
            driverBuilder.setBearerToken(bearerToken);
        } else {
            String kerberosTicket = config.getString(Neo4jBaseOptions.KEY_KERBEROS_TICKET.key());
            AuthTokens.kerberos(kerberosTicket);
            driverBuilder.setBearerToken(kerberosTicket);
        }
        driverBuilder.setDatabase(config.getString(Neo4jBaseOptions.KEY_DATABASE.key()));
        if (config.hasPath(Neo4jBaseOptions.KEY_MAX_CONNECTION_TIMEOUT.key())) {
            driverBuilder.setMaxConnectionTimeoutSeconds(config.getLong(Neo4jBaseOptions.KEY_MAX_CONNECTION_TIMEOUT.key()));
        }
        if (config.hasPath(Neo4jBaseOptions.KEY_MAX_TRANSACTION_RETRY_TIME.key())) {
            driverBuilder.setMaxTransactionRetryTimeSeconds(config.getLong(Neo4jBaseOptions.KEY_MAX_TRANSACTION_RETRY_TIME.key()));
        }
        return driverBuilder;
    }

    private String prepareQuery(Config config, PluginType pluginType) {
        CheckResult queryConfigCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jBaseOptions.KEY_QUERY.key()});
        if (!queryConfigCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", pluginType, queryConfigCheck.getMsg()));
        }
        return config.getString(Neo4jBaseOptions.KEY_QUERY.key());
    }

    public DriverBuilder getDriverBuilder() {
        return this.driverBuilder;
    }

    public String getQuery() {
        return this.query;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setDriverBuilder(DriverBuilder driverBuilder) {
        this.driverBuilder = driverBuilder;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Neo4jQueryInfo)) {
            return false;
        }
        Neo4jQueryInfo other = (Neo4jQueryInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DriverBuilder this$driverBuilder = this.getDriverBuilder();
        DriverBuilder other$driverBuilder = other.getDriverBuilder();
        if (this$driverBuilder == null ? other$driverBuilder != null : !this$driverBuilder.equals(other$driverBuilder)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        PluginType this$pluginType = this.getPluginType();
        PluginType other$pluginType = other.getPluginType();
        return !(this$pluginType == null ? other$pluginType != null : !this$pluginType.equals(other$pluginType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Neo4jQueryInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DriverBuilder $driverBuilder = this.getDriverBuilder();
        result = result * 59 + ($driverBuilder == null ? 43 : $driverBuilder.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        PluginType $pluginType = this.getPluginType();
        result = result * 59 + ($pluginType == null ? 43 : $pluginType.hashCode());
        return result;
    }

    public String toString() {
        return "Neo4jQueryInfo(driverBuilder=" + this.getDriverBuilder() + ", query=" + this.getQuery() + ", pluginType=" + this.getPluginType() + ")";
    }
}

