/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.utils.source;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.KeyValuePair;
import io.milvus.response.QueryResultsWrapper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.api.table.type.VectorType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.VectorUtils;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectorException;

public class MilvusSourceConverter {
    private final List<String> existField;
    private Gson gson = new Gson();

    public MilvusSourceConverter(TableSchema tableSchema) {
        this.existField = tableSchema.getColumns().stream().filter(column -> column.getOptions() == null || !column.getOptions().containsValue(CommonOptions.METADATA)).map(Column::getName).collect(Collectors.toList());
    }

    public SeaTunnelRow convertToSeaTunnelRow(QueryResultsWrapper.RowRecord record, TableSchema tableSchema, TablePath tablePath) {
        SeaTunnelRowType typeInfo = tableSchema.toPhysicalRowDataType();
        String[] fieldNames = typeInfo.getFieldNames();
        Object[] seatunnelField = new Object[typeInfo.getTotalFields()];
        Map<String, Object> fieldValuesMap = record.getFieldValues();
        JsonObject dynamicField = this.convertDynamicField(fieldValuesMap);
        block24: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            if (fieldNames[fieldIndex].equals(CommonOptions.METADATA.getName())) {
                seatunnelField[fieldIndex] = dynamicField.toString();
                continue;
            }
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            Object fieldValues = fieldValuesMap.get(fieldNames[fieldIndex]);
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    seatunnelField[fieldIndex] = fieldValues.toString();
                    continue block24;
                }
                case BOOLEAN: {
                    if (fieldValues instanceof Boolean) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    seatunnelField[fieldIndex] = Boolean.valueOf(fieldValues.toString());
                    continue block24;
                }
                case TINYINT: {
                    if (fieldValues instanceof Byte) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    seatunnelField[fieldIndex] = Byte.parseByte(fieldValues.toString());
                    continue block24;
                }
                case SMALLINT: {
                    seatunnelField[fieldIndex] = fieldValues instanceof Short ? fieldValues : Short.valueOf(Short.parseShort(fieldValues.toString()));
                }
                case INT: {
                    if (fieldValues instanceof Integer) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    seatunnelField[fieldIndex] = Integer.valueOf(fieldValues.toString());
                    continue block24;
                }
                case BIGINT: {
                    if (fieldValues instanceof Long) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    seatunnelField[fieldIndex] = Long.parseLong(fieldValues.toString());
                    continue block24;
                }
                case FLOAT: {
                    if (fieldValues instanceof Float) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    seatunnelField[fieldIndex] = Float.valueOf(Float.parseFloat(fieldValues.toString()));
                    continue block24;
                }
                case DOUBLE: {
                    if (fieldValues instanceof Double) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    seatunnelField[fieldIndex] = Double.parseDouble(fieldValues.toString());
                    continue block24;
                }
                case ARRAY: {
                    List list;
                    if (fieldValues instanceof List) {
                        list = (List)fieldValues;
                        ArrayType arrayType = (ArrayType)seaTunnelDataType;
                        SqlType elementType = arrayType.getElementType().getSqlType();
                        switch (elementType) {
                            case STRING: {
                                String[] arrays = new String[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    arrays[i] = list.get(i).toString();
                                }
                                seatunnelField[fieldIndex] = arrays;
                                continue block24;
                            }
                            case BOOLEAN: {
                                Boolean[] booleanArrays = new Boolean[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    booleanArrays[i] = Boolean.valueOf(list.get(i).toString());
                                }
                                seatunnelField[fieldIndex] = booleanArrays;
                                continue block24;
                            }
                            case TINYINT: {
                                Byte[] byteArrays = new Byte[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    byteArrays[i] = Byte.parseByte(list.get(i).toString());
                                }
                                seatunnelField[fieldIndex] = byteArrays;
                                continue block24;
                            }
                            case SMALLINT: {
                                Short[] shortArrays = new Short[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    shortArrays[i] = Short.parseShort(list.get(i).toString());
                                }
                                seatunnelField[fieldIndex] = shortArrays;
                                continue block24;
                            }
                            case INT: {
                                Integer[] intArrays = new Integer[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    intArrays[i] = Integer.valueOf(list.get(i).toString());
                                }
                                seatunnelField[fieldIndex] = intArrays;
                                continue block24;
                            }
                            case BIGINT: {
                                Long[] longArrays = new Long[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    longArrays[i] = Long.parseLong(list.get(i).toString());
                                }
                                seatunnelField[fieldIndex] = longArrays;
                                continue block24;
                            }
                            case FLOAT: {
                                Float[] floatArrays = new Float[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    floatArrays[i] = Float.valueOf(Float.parseFloat(list.get(i).toString()));
                                }
                                seatunnelField[fieldIndex] = floatArrays;
                                continue block24;
                            }
                            case DOUBLE: {
                                Double[] doubleArrays = new Double[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    doubleArrays[i] = Double.parseDouble(list.get(i).toString());
                                }
                                seatunnelField[fieldIndex] = doubleArrays;
                                continue block24;
                            }
                        }
                        throw new MilvusConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected array value: " + fieldValues);
                    }
                    throw new MilvusConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected array value: " + fieldValues);
                }
                case FLOAT_VECTOR: {
                    List list;
                    if (fieldValues instanceof List) {
                        list = (List)fieldValues;
                        Float[] arrays = new Float[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            arrays[i] = Float.valueOf(Float.parseFloat(list.get(i).toString()));
                        }
                        seatunnelField[fieldIndex] = VectorUtils.toByteBuffer((Float[])arrays);
                        continue block24;
                    }
                    throw new MilvusConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected vector value: " + fieldValues);
                }
                case BINARY_VECTOR: 
                case FLOAT16_VECTOR: 
                case BFLOAT16_VECTOR: {
                    if (fieldValues instanceof ByteBuffer) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    throw new MilvusConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected vector value: " + fieldValues);
                }
                case SPARSE_FLOAT_VECTOR: {
                    if (fieldValues instanceof Map) {
                        seatunnelField[fieldIndex] = fieldValues;
                        continue block24;
                    }
                    throw new MilvusConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected vector value: " + fieldValues);
                }
                default: {
                    throw new MilvusConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType.getSqlType().name());
                }
            }
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(seatunnelField);
        seaTunnelRow.setTableId(tablePath.getFullName());
        seaTunnelRow.setRowKind(RowKind.INSERT);
        return seaTunnelRow;
    }

    public static PhysicalColumn convertColumn(FieldSchema fieldSchema) {
        DataType dataType = fieldSchema.getDataType();
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder();
        builder.name(fieldSchema.getName());
        builder.sourceType(dataType.name());
        builder.comment(fieldSchema.getDescription());
        block0 : switch (dataType) {
            case Bool: {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case Int8: {
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case Int16: {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case Int32: {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case Int64: {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case Float: {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case Double: {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case VarChar: {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
                    if (!keyValuePair.getKey().equals("max_length")) continue;
                    builder.columnLength(Long.valueOf(Long.parseLong(keyValuePair.getValue()) * 4L));
                    break block0;
                }
                break;
            }
            case String: {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case JSON: {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put(CommonOptions.JSON.getName(), true);
                builder.options(options);
                break;
            }
            case Array: {
                builder.dataType((SeaTunnelDataType)ArrayType.STRING_ARRAY_TYPE);
                break;
            }
            case FloatVector: {
                builder.dataType((SeaTunnelDataType)VectorType.VECTOR_FLOAT_TYPE);
                for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
                    if (!keyValuePair.getKey().equals("dim")) continue;
                    builder.scale(Integer.valueOf(keyValuePair.getValue()));
                    break block0;
                }
                break;
            }
            case BinaryVector: {
                builder.dataType((SeaTunnelDataType)VectorType.VECTOR_BINARY_TYPE);
                for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
                    if (!keyValuePair.getKey().equals("dim")) continue;
                    builder.scale(Integer.valueOf(keyValuePair.getValue()));
                    break block0;
                }
                break;
            }
            case SparseFloatVector: {
                builder.dataType((SeaTunnelDataType)VectorType.VECTOR_SPARSE_FLOAT_TYPE);
                break;
            }
            case Float16Vector: {
                builder.dataType((SeaTunnelDataType)VectorType.VECTOR_FLOAT16_TYPE);
                for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
                    if (!keyValuePair.getKey().equals("dim")) continue;
                    builder.scale(Integer.valueOf(keyValuePair.getValue()));
                    break block0;
                }
                break;
            }
            case BFloat16Vector: {
                builder.dataType((SeaTunnelDataType)VectorType.VECTOR_BFLOAT16_TYPE);
                for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
                    if (!keyValuePair.getKey().equals("dim")) continue;
                    builder.scale(Integer.valueOf(keyValuePair.getValue()));
                    break block0;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dataType);
            }
        }
        return builder.build();
    }

    private JsonObject convertDynamicField(Map<String, Object> fieldValuesMap) {
        JsonObject dynamicField = new JsonObject();
        for (Map.Entry<String, Object> entry : fieldValuesMap.entrySet()) {
            if (this.existField.contains(entry.getKey())) continue;
            dynamicField.add(entry.getKey(), this.gson.toJsonTree(entry.getValue()));
        }
        return dynamicField;
    }
}

