/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.utils;

import com.google.protobuf.ProtocolStringList;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.ShowType;
import io.milvus.param.ConnectParam;
import io.milvus.param.R;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.partition.ShowPartitionsParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.MetadataColumn;
import org.apache.seatunnel.api.table.catalog.MetadataSchema;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.VectorIndex;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.milvus.config.MilvusSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectionErrorCode;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectorException;
import org.apache.seatunnel.connectors.seatunnel.milvus.utils.source.MilvusSourceConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(MilvusConvertUtils.class);
    private final ReadonlyConfig config;

    public MilvusConvertUtils(ReadonlyConfig config) {
        this.config = config;
    }

    public Map<TablePath, CatalogTable> getSourceTables() {
        MilvusServiceClient client = new MilvusServiceClient(ConnectParam.newBuilder().withUri((String)this.config.get(MilvusSourceOptions.URL)).withToken((String)this.config.get(MilvusSourceOptions.TOKEN)).build());
        String database = (String)this.config.get(MilvusSourceOptions.DATABASE);
        ArrayList<Object> collectionList = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.config.get(MilvusSourceOptions.COLLECTION))) {
            collectionList.add(this.config.get(MilvusSourceOptions.COLLECTION));
        } else {
            R<ShowCollectionsResponse> response = client.showCollections(ShowCollectionsParam.newBuilder().withDatabaseName(database).withShowType(ShowType.All).build());
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new MilvusConnectorException(MilvusConnectionErrorCode.SHOW_COLLECTIONS_ERROR);
            }
            ProtocolStringList collections = response.getData().getCollectionNamesList();
            if (CollectionUtils.isEmpty(collections)) {
                throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.DATABASE_NO_COLLECTIONS, database);
            }
            collectionList.addAll(collections);
        }
        HashMap<TablePath, CatalogTable> map = new HashMap<TablePath, CatalogTable>();
        for (String string : collectionList) {
            CatalogTable catalogTable = this.getCatalogTable(client, database, string);
            TablePath tablePath = TablePath.of((String)database, null, (String)string);
            map.put(tablePath, catalogTable);
        }
        client.close();
        return map;
    }

    public CatalogTable getCatalogTable(MilvusServiceClient client, String database, String collection) {
        R<DescribeCollectionResponse> response = client.describeCollection(DescribeCollectionParam.newBuilder().withDatabaseName(database).withCollectionName(collection).build());
        if (response.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.DESC_COLLECTION_ERROR, response.getMessage());
        }
        log.info("describe collection database: {}, collection: {}, response: {}", new Object[]{database, collection, response});
        DescribeCollectionResponse collectionResponse = response.getData();
        CollectionSchema schema = collectionResponse.getSchema();
        ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
        boolean existPartitionKeyField = false;
        String partitionKeyField = null;
        for (FieldSchema fieldSchema : schema.getFieldsList()) {
            PhysicalColumn physicalColumn = MilvusSourceConverter.convertColumn(fieldSchema);
            columns.add(physicalColumn);
            if (!fieldSchema.getIsPartitionKey()) continue;
            existPartitionKeyField = true;
            partitionKeyField = fieldSchema.getName();
        }
        if (collectionResponse.getSchema().getEnableDynamicField()) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put(CommonOptions.METADATA.getName(), true);
            PhysicalColumn dynamicColumn = PhysicalColumn.builder().name(CommonOptions.METADATA.getName()).dataType((SeaTunnelDataType)BasicType.STRING_TYPE).options(options).build();
            columns.add(dynamicColumn);
        }
        PrimaryKey primaryKey = MilvusConvertUtils.buildPrimaryKey(schema.getFieldsList());
        R<DescribeIndexResponse> describeIndexResponseR = client.describeIndex(DescribeIndexParam.newBuilder().withDatabaseName(database).withCollectionName(collection).build());
        if (describeIndexResponseR.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new MilvusConnectorException(MilvusConnectionErrorCode.DESC_INDEX_ERROR);
        }
        DescribeIndexResponse indexResponse = describeIndexResponseR.getData();
        List<ConstraintKey.ConstraintKeyColumn> vectorIndexes = MilvusConvertUtils.buildVectorIndexes(indexResponse);
        TableSchema tableSchema = TableSchema.builder().columns(columns).primaryKey(primaryKey).constraintKey(ConstraintKey.of((ConstraintKey.ConstraintType)ConstraintKey.ConstraintType.VECTOR_INDEX_KEY, (String)"vector_index", vectorIndexes)).build();
        String CATALOG_NAME = "Milvus";
        TableIdentifier tableId = TableIdentifier.of((String)CATALOG_NAME, (String)database, null, (String)collection);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("enableDynamicField", String.valueOf(schema.getEnableDynamicField()));
        options.put("shardsNum", String.valueOf(collectionResponse.getShardsNum()));
        MetadataSchema.Builder metadataBuilder = MetadataSchema.builder();
        if (existPartitionKeyField) {
            options.put("partitionKeyField", partitionKeyField);
            metadataBuilder.column((Column)MetadataColumn.of((String)CommonOptions.PARTITION.getName(), (SeaTunnelDataType)BasicType.STRING_TYPE, null, (boolean)true, null, null));
        } else {
            MilvusConvertUtils.fillPartitionNames(options, client, database, collection);
        }
        return CatalogTable.of((TableIdentifier)tableId, (TableSchema)tableSchema, options, new ArrayList(), (String)schema.getDescription(), (String)tableId.getCatalogName(), (MetadataSchema)metadataBuilder.build());
    }

    private static void fillPartitionNames(Map<String, String> options, MilvusServiceClient client, String database, String collection) {
        R<ShowPartitionsResponse> partitionsResponseR = client.showPartitions(ShowPartitionsParam.newBuilder().withDatabaseName(database).withCollectionName(collection).build());
        if (partitionsResponseR.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.SHOW_PARTITION_ERROR, partitionsResponseR.getMessage());
        }
        ProtocolStringList partitionNamesList = partitionsResponseR.getData().getPartitionNamesList();
        ArrayList<String> list = new ArrayList<String>();
        for (String partition : partitionNamesList) {
            if (partition.equals("_default")) continue;
            list.add(partition);
        }
        if (CollectionUtils.isEmpty(partitionNamesList)) {
            return;
        }
        options.put("partitionNames", String.join((CharSequence)",", list));
    }

    private static List<ConstraintKey.ConstraintKeyColumn> buildVectorIndexes(DescribeIndexResponse indexResponse) {
        if (CollectionUtils.isEmpty(indexResponse.getIndexDescriptionsList())) {
            return null;
        }
        ArrayList<ConstraintKey.ConstraintKeyColumn> list = new ArrayList<ConstraintKey.ConstraintKeyColumn>();
        for (IndexDescription per : indexResponse.getIndexDescriptionsList()) {
            Map<String, String> paramsMap = per.getParamsList().stream().collect(Collectors.toMap(KeyValuePair::getKey, KeyValuePair::getValue));
            VectorIndex index = new VectorIndex(per.getIndexName(), per.getFieldName(), paramsMap.get("index_type"), paramsMap.get("metric_type"));
            list.add((ConstraintKey.ConstraintKeyColumn)index);
        }
        return list;
    }

    public static PrimaryKey buildPrimaryKey(List<FieldSchema> fields) {
        for (FieldSchema field : fields) {
            if (!field.getIsPrimaryKey()) continue;
            return PrimaryKey.of((String)field.getName(), Arrays.asList(field.getName()), (Boolean)field.getAutoID());
        }
        return null;
    }
}

