/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.utils;

import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusConnectorUtils {
    private static final Logger log = LoggerFactory.getLogger(MilvusConnectorUtils.class);

    public static Boolean hasPartitionKey(MilvusClientV2 milvusClient, String collectionName) {
        DescribeCollectionResp describeCollectionResp = milvusClient.describeCollection((DescribeCollectionReq)((DescribeCollectionReq.DescribeCollectionReqBuilder)DescribeCollectionReq.builder().collectionName(collectionName)).build());
        return describeCollectionResp.getCollectionSchema().getFieldSchemaList().stream().anyMatch(CreateCollectionReq.FieldSchema::getIsPartitionKey);
    }

    public static String getDynamicField(CatalogTable catalogTable) {
        List columns = catalogTable.getTableSchema().getColumns();
        Column dynamicField = null;
        for (Column column : columns) {
            if (column.getOptions() == null || !column.getOptions().getOrDefault(CommonOptions.METADATA.getName(), false).booleanValue()) continue;
            dynamicField = column;
        }
        return dynamicField == null ? null : dynamicField.getName();
    }

    public static List<String> getJsonField(CatalogTable catalogTable) {
        List columns = catalogTable.getTableSchema().getColumns();
        ArrayList<String> jsonColumn = new ArrayList<String>();
        for (Column column : columns) {
            if (column.getOptions() == null || !column.getOptions().containsKey(CommonOptions.JSON.getName()) || !((Boolean)column.getOptions().get(CommonOptions.JSON.getName())).booleanValue()) continue;
            jsonColumn.add(column.getName());
        }
        return jsonColumn;
    }
}

