/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.milvus.config.MilvusSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.milvus.source.MilvusSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class MilvusSourceFactory
implements TableSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(MilvusSourceFactory.class);

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new MilvusSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{MilvusSourceOptions.URL, MilvusSourceOptions.TOKEN}).optional(new Option[]{MilvusSourceOptions.DATABASE, MilvusSourceOptions.COLLECTION}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return MilvusSource.class;
    }

    public String factoryIdentifier() {
        return "Milvus";
    }
}

