/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.milvus.source.MilvusSourceReader;
import org.apache.seatunnel.connectors.seatunnel.milvus.source.MilvusSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.milvus.source.MilvusSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.milvus.source.MilvusSourceState;
import org.apache.seatunnel.connectors.seatunnel.milvus.utils.MilvusConvertUtils;

public class MilvusSource
implements SeaTunnelSource<SeaTunnelRow, MilvusSourceSplit, MilvusSourceState>,
SupportParallelism,
SupportColumnProjection {
    private final ReadonlyConfig config;
    private final Map<TablePath, CatalogTable> sourceTables;

    public MilvusSource(ReadonlyConfig sourceConfig) {
        this.config = sourceConfig;
        MilvusConvertUtils milvusConvertUtils = new MilvusConvertUtils(sourceConfig);
        this.sourceTables = milvusConvertUtils.getSourceTables();
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return new ArrayList<CatalogTable>(this.sourceTables.values());
    }

    public SourceReader<SeaTunnelRow, MilvusSourceSplit> createReader(SourceReader.Context readerContext) throws Exception {
        return new MilvusSourceReader(readerContext, this.config, this.sourceTables);
    }

    public SourceSplitEnumerator<MilvusSourceSplit, MilvusSourceState> createEnumerator(SourceSplitEnumerator.Context<MilvusSourceSplit> context) throws Exception {
        return new MilvusSourceSplitEnumerator(context, this.config, this.sourceTables, null);
    }

    public SourceSplitEnumerator<MilvusSourceSplit, MilvusSourceState> restoreEnumerator(SourceSplitEnumerator.Context<MilvusSourceSplit> context, MilvusSourceState checkpointState) throws Exception {
        return new MilvusSourceSplitEnumerator(context, this.config, this.sourceTables, checkpointState);
    }

    public String getPluginName() {
        return "Milvus";
    }
}

