/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.sink;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectionErrorCode;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectorException;
import org.apache.seatunnel.connectors.seatunnel.milvus.sink.MilvusBufferBatchWriter;
import org.apache.seatunnel.connectors.seatunnel.milvus.state.MilvusCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.milvus.state.MilvusSinkState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusSinkWriter
implements SinkWriter<SeaTunnelRow, MilvusCommitInfo, MilvusSinkState> {
    private static final Logger log = LoggerFactory.getLogger(MilvusSinkWriter.class);
    private final MilvusBufferBatchWriter batchWriter;
    private ReadonlyConfig config;

    public MilvusSinkWriter(SinkWriter.Context context, CatalogTable catalogTable, ReadonlyConfig config, List<MilvusSinkState> milvusSinkStates) {
        this.batchWriter = new MilvusBufferBatchWriter(catalogTable, config);
        this.config = config;
        log.info("create Milvus sink writer success");
        log.info("MilvusSinkWriter config: " + config);
    }

    public void write(SeaTunnelRow element) {
        this.batchWriter.addToBatch(element);
        if (this.batchWriter.needFlush()) {
            try {
                this.batchWriter.flush();
            }
            catch (Exception e) {
                log.error("flush Milvus sink writer failed", (Throwable)e);
                throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.WRITE_DATA_FAIL, e);
            }
        }
    }

    public Optional<MilvusCommitInfo> prepareCommit() throws IOException {
        return Optional.empty();
    }

    public void abortPrepare() {
    }

    public void close() throws IOException {
        try {
            log.info("Stopping Milvus Client");
            this.batchWriter.flush();
            this.batchWriter.close();
            log.info("Stop Milvus Client success");
        }
        catch (Exception e) {
            log.error("Stop Milvus Client failed", (Throwable)e);
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.CLOSE_CLIENT_ERROR, e);
        }
    }
}

