/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.sink;

import com.google.auto.service.AutoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.milvus.config.MilvusSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.milvus.sink.MilvusSink;

@AutoService(value={Factory.class})
public class MilvusSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Milvus";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{MilvusSinkOptions.URL, MilvusSinkOptions.TOKEN}).optional(new Option[]{MilvusSinkOptions.ENABLE_UPSERT, MilvusSinkOptions.ENABLE_DYNAMIC_FIELD, MilvusSinkOptions.ENABLE_AUTO_ID, MilvusSinkOptions.SCHEMA_SAVE_MODE, MilvusSinkOptions.DATA_SAVE_MODE}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = this.renameCatalogTable(config, context.getCatalogTable());
        return () -> new MilvusSink(config, catalogTable);
    }

    private CatalogTable renameCatalogTable(ReadonlyConfig config, CatalogTable sourceCatalogTable) {
        TableIdentifier sourceTable = sourceCatalogTable.getTableId();
        String databaseName = StringUtils.isNotEmpty((CharSequence)config.get(MilvusSinkOptions.DATABASE)) ? (String)config.get(MilvusSinkOptions.DATABASE) : sourceTable.getDatabaseName();
        String tableName = StringUtils.isNotEmpty((CharSequence)config.get(MilvusSinkOptions.COLLECTION)) ? (String)config.get(MilvusSinkOptions.COLLECTION) : sourceTable.getTableName();
        TableIdentifier newTableId = TableIdentifier.of((String)sourceTable.getCatalogName(), (String)databaseName, (String)sourceTable.getSchemaName(), (String)tableName);
        return CatalogTable.of((TableIdentifier)newTableId, (CatalogTable)sourceCatalogTable);
    }
}

