/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.sink;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.milvus.catalog.MilvusCatalogFactory;
import org.apache.seatunnel.connectors.seatunnel.milvus.config.MilvusSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.milvus.sink.MilvusSinkCommitter;
import org.apache.seatunnel.connectors.seatunnel.milvus.sink.MilvusSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.milvus.state.MilvusAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.milvus.state.MilvusCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.milvus.state.MilvusSinkState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusSink
implements SeaTunnelSink<SeaTunnelRow, MilvusSinkState, MilvusCommitInfo, MilvusAggregatedCommitInfo>,
SupportSaveMode {
    private static final Logger log = LoggerFactory.getLogger(MilvusSink.class);
    private final ReadonlyConfig config;
    private final CatalogTable catalogTable;

    public MilvusSink(ReadonlyConfig config, CatalogTable catalogTable) {
        this.config = config;
        this.catalogTable = catalogTable;
    }

    public SinkWriter<SeaTunnelRow, MilvusCommitInfo, MilvusSinkState> createWriter(SinkWriter.Context context) {
        return new MilvusSinkWriter(context, this.catalogTable, this.config, Collections.emptyList());
    }

    public SinkWriter<SeaTunnelRow, MilvusCommitInfo, MilvusSinkState> restoreWriter(SinkWriter.Context context, List<MilvusSinkState> states) {
        return new MilvusSinkWriter(context, this.catalogTable, this.config, states);
    }

    public Optional<Serializer<MilvusSinkState>> getWriterStateSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SinkCommitter<MilvusCommitInfo>> createCommitter() {
        return Optional.of(new MilvusSinkCommitter(this.config));
    }

    public Optional<Serializer<MilvusCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public String getPluginName() {
        return "Milvus";
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        if (this.catalogTable == null) {
            return Optional.empty();
        }
        MilvusCatalogFactory catalogFactory = new MilvusCatalogFactory();
        Catalog catalog = catalogFactory.createCatalog(this.catalogTable.getCatalogName(), this.config);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)this.config.get(MilvusSinkOptions.SCHEMA_SAVE_MODE);
        DataSaveMode dataSaveMode = (DataSaveMode)this.config.get(MilvusSinkOptions.DATA_SAVE_MODE);
        return Optional.of(new DefaultSaveModeHandler(schemaSaveMode, dataSaveMode, catalog, this.catalogTable.getTablePath(), this.catalogTable, null));
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }
}

