/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.milvus.catalog;

import com.google.protobuf.ProtocolStringList;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.grpc.ListDatabasesResponse;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.ShowType;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.CreateDatabaseParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.DropDatabaseParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.ShowPartitionsParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.InfoPreviewResult;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.VectorIndex;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.milvus.config.MilvusSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectionErrorCode;
import org.apache.seatunnel.connectors.seatunnel.milvus.exception.MilvusConnectorException;
import org.apache.seatunnel.connectors.seatunnel.milvus.utils.sink.MilvusSinkConverter;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(MilvusCatalog.class);
    private final String catalogName;
    private final ReadonlyConfig config;
    private MilvusServiceClient client;

    public MilvusCatalog(String catalogName, ReadonlyConfig config) {
        this.catalogName = catalogName;
        this.config = config;
    }

    public void open() throws CatalogException {
        ConnectParam connectParam = ConnectParam.newBuilder().withUri((String)this.config.get(MilvusSinkOptions.URL)).withToken((String)this.config.get(MilvusSinkOptions.TOKEN)).build();
        try {
            this.client = new MilvusServiceClient(connectParam);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to open catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void close() throws CatalogException {
        this.client.close();
    }

    public String name() {
        return this.catalogName;
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            return new InfoPreviewResult("create collection " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new InfoPreviewResult("drop collection " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new InfoPreviewResult("create database " + tablePath.getDatabaseName());
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new InfoPreviewResult("drop database " + tablePath.getDatabaseName());
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }

    public String getDefaultDatabase() throws CatalogException {
        return "default";
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        List<String> databases = this.listDatabases();
        return databases.contains(databaseName);
    }

    public List<String> listDatabases() throws CatalogException {
        R<ListDatabasesResponse> response = this.client.listDatabases();
        return response.getData().getDbNamesList();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        R<ShowCollectionsResponse> response = this.client.showCollections(ShowCollectionsParam.newBuilder().withDatabaseName(databaseName).withShowType(ShowType.All).build());
        return response.getData().getCollectionNamesList();
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        R<Boolean> response = this.client.hasCollection(HasCollectionParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).withCollectionName(tablePath.getTableName()).build());
        if (response.getData() != null) {
            return response.getData();
        }
        throw new MilvusConnectorException(MilvusConnectionErrorCode.SERVER_RESPONSE_FAILED, response.getMessage(), response.getException());
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        throw new RuntimeException("not implemented");
    }

    public void createTable(TablePath tablePath, CatalogTable catalogTable, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.catalogName, tablePath);
        }
        Preconditions.checkNotNull((Object)catalogTable, (Object)"catalogTable must not be null");
        TableSchema tableSchema = catalogTable.getTableSchema();
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema must not be null");
        this.createTableInternal(tablePath, catalogTable);
        if (CollectionUtils.isNotEmpty(tableSchema.getConstraintKeys()) && ((Boolean)this.config.get(MilvusSinkOptions.CREATE_INDEX)).booleanValue()) {
            for (ConstraintKey constraintKey : tableSchema.getConstraintKeys()) {
                if (!constraintKey.getConstraintType().equals((Object)ConstraintKey.ConstraintType.VECTOR_INDEX_KEY)) continue;
                this.createIndexInternal(tablePath, constraintKey.getColumnNames());
            }
        }
    }

    private void createIndexInternal(TablePath tablePath, List<ConstraintKey.ConstraintKeyColumn> vectorIndexes) {
        for (ConstraintKey.ConstraintKeyColumn column : vectorIndexes) {
            VectorIndex index = (VectorIndex)column;
            CreateIndexParam createIndexParam = CreateIndexParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).withCollectionName(tablePath.getTableName()).withFieldName(index.getColumnName()).withIndexName(index.getIndexName()).withIndexType(IndexType.valueOf(index.getIndexType().name())).withMetricType(MetricType.valueOf(index.getMetricType().name())).build();
            R<RpcStatus> response = this.client.createIndex(createIndexParam);
            if (Objects.equals(response.getStatus(), R.success().getStatus())) continue;
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.CREATE_INDEX_ERROR, response.getMessage());
        }
    }

    public void createTableInternal(TablePath tablePath, CatalogTable catalogTable) {
        try {
            CreateCollectionParam createCollectionParam;
            R<RpcStatus> response;
            String partitionKeyField;
            Map options = catalogTable.getOptions();
            boolean existPartitionKeyField = options.containsKey("partitionKeyField");
            String string = partitionKeyField = existPartitionKeyField ? (String)options.get("partitionKeyField") : null;
            if (StringUtils.isNotEmpty((CharSequence)this.config.get(MilvusSinkOptions.PARTITION_KEY))) {
                existPartitionKeyField = true;
                partitionKeyField = (String)this.config.get(MilvusSinkOptions.PARTITION_KEY);
            }
            TableSchema tableSchema = catalogTable.getTableSchema();
            ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
            for (Column column : tableSchema.getColumns()) {
                if (column.getOptions() != null && column.getOptions().containsKey(CommonOptions.METADATA.getName()) && ((Boolean)column.getOptions().get(CommonOptions.METADATA.getName())).booleanValue()) continue;
                FieldType fieldType = MilvusSinkConverter.convertToFieldType(column, tableSchema.getPrimaryKey(), partitionKeyField, (Boolean)this.config.get(MilvusSinkOptions.ENABLE_AUTO_ID));
                fieldTypes.add(fieldType);
            }
            Boolean enableDynamicField = options.containsKey("enableDynamicField") ? Boolean.valueOf((String)options.get("enableDynamicField")) : (Boolean)this.config.get(MilvusSinkOptions.ENABLE_DYNAMIC_FIELD);
            String collectionDescription = "";
            if (this.config.get(MilvusSinkOptions.COLLECTION_DESCRIPTION) != null && ((Map)this.config.get(MilvusSinkOptions.COLLECTION_DESCRIPTION)).containsKey(tablePath.getTableName())) {
                collectionDescription = (String)((Map)this.config.get(MilvusSinkOptions.COLLECTION_DESCRIPTION)).get(tablePath.getTableName());
            } else if (null != catalogTable.getComment()) {
                collectionDescription = catalogTable.getComment();
            }
            CreateCollectionParam.Builder builder = CreateCollectionParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).withCollectionName(tablePath.getTableName()).withDescription(collectionDescription).withFieldTypes(fieldTypes).withEnableDynamicField(enableDynamicField).withConsistencyLevel(ConsistencyLevelEnum.BOUNDED);
            if (StringUtils.isNotEmpty((CharSequence)options.get("shardsNum"))) {
                builder.withShardsNum(Integer.parseInt((String)options.get("shardsNum")));
            }
            if (!Objects.equals((response = this.client.createCollection(createCollectionParam = builder.build())).getStatus(), R.success().getStatus())) {
                throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.CREATE_COLLECTION_ERROR, response.getMessage());
            }
            if (!existPartitionKeyField && options.containsKey("partitionKeyField")) {
                this.createPartitionInternal((String)options.get("partitionKeyField"), tablePath);
            }
        }
        catch (Exception e) {
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.CREATE_COLLECTION_ERROR, e);
        }
    }

    private void createPartitionInternal(String partitionNames, TablePath tablePath) {
        String[] partitionNameArray;
        R<ShowPartitionsResponse> showPartitionsResponseR = this.client.showPartitions(ShowPartitionsParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).withCollectionName(tablePath.getTableName()).build());
        if (!Objects.equals(showPartitionsResponseR.getStatus(), R.success().getStatus())) {
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.SHOW_PARTITION_ERROR, showPartitionsResponseR.getMessage());
        }
        ProtocolStringList existPartitionNames = showPartitionsResponseR.getData().getPartitionNamesList();
        for (String partitionName : partitionNameArray = partitionNames.split(",")) {
            if (existPartitionNames.contains(partitionName)) continue;
            R<RpcStatus> response = this.client.createPartition(CreatePartitionParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).withCollectionName(tablePath.getTableName()).withPartitionName(partitionName).build());
            if (R.success().getStatus().equals(response.getStatus())) continue;
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.CREATE_PARTITION_ERROR, response.getMessage());
        }
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
        if (!this.tableExists(tablePath)) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.catalogName, tablePath);
            }
            return;
        }
        this.client.dropCollection(DropCollectionParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).withCollectionName(tablePath.getTableName()).build());
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (this.databaseExists(tablePath.getDatabaseName())) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.catalogName, tablePath.getDatabaseName());
            }
            return;
        }
        R<RpcStatus> response = this.client.createDatabase(CreateDatabaseParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).build());
        if (!R.success().getStatus().equals(response.getStatus())) {
            throw new MilvusConnectorException((SeaTunnelErrorCode)MilvusConnectionErrorCode.CREATE_DATABASE_ERROR, response.getMessage());
        }
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
            }
            return;
        }
        this.client.dropDatabase(DropDatabaseParam.newBuilder().withDatabaseName(tablePath.getDatabaseName()).build());
    }
}

