/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.reflect.TypeToken;
import io.milvus.common.utils.JsonUtils;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FunctionSchema;
import io.milvus.grpc.FunctionType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.ValueField;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);

    public static void checkNullEmptyString(String target, String title) {
        if (target == null || StringUtils.isBlank(target)) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, title + " cannot be null or empty");
        }
    }

    public static FieldSchema convertToGrpcFieldSchema(CreateCollectionReq.FieldSchema fieldSchema) {
        List<KeyValuePair> typeParamsList;
        String params;
        Map<Object, Object> typeParams;
        SchemaUtils.checkNullEmptyString(fieldSchema.getName(), "Field name");
        io.milvus.grpc.DataType dType = io.milvus.grpc.DataType.valueOf(fieldSchema.getDataType().name());
        FieldSchema.Builder builder = FieldSchema.newBuilder().setName(fieldSchema.getName()).setDescription(fieldSchema.getDescription()).setDataType(dType).setIsPrimaryKey(fieldSchema.getIsPrimaryKey()).setIsPartitionKey(fieldSchema.getIsPartitionKey()).setIsClusteringKey(fieldSchema.getIsClusteringKey()).setAutoID(fieldSchema.getAutoID()).setNullable(fieldSchema.getIsNullable());
        if (!ParamUtils.isVectorDataType(dType) && !fieldSchema.getIsPrimaryKey().booleanValue()) {
            ValueField value = ParamUtils.objectToValueField(fieldSchema.getDefaultValue(), dType);
            if (value != null) {
                builder.setDefaultValue(value);
            } else if (fieldSchema.getDefaultValue() != null) {
                String msg = String.format("Illegal default value for %s type field. Please use Short for Int8/Int16 fields, Short/Integer for Int32 fields, Short/Integer/Long for Int64 fields, Boolean for Bool fields, String for Varchar fields, JsonObject for JSON fields.", dType.name());
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
            }
        }
        Map<Object, Object> map = typeParams = fieldSchema.getTypeParams() == null ? new HashMap() : fieldSchema.getTypeParams();
        if (fieldSchema.getDimension() != null) {
            typeParams.put("dim", String.valueOf(fieldSchema.getDimension()));
        }
        if (fieldSchema.getDataType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
            typeParams.put("max_length", String.valueOf(fieldSchema.getMaxLength()));
        }
        if (fieldSchema.getDataType() == DataType.Array) {
            builder.setElementType(io.milvus.grpc.DataType.valueOf(fieldSchema.getElementType().name())).build();
            if (fieldSchema.getMaxCapacity() != null) {
                typeParams.put("max_capacity", String.valueOf(fieldSchema.getMaxCapacity()));
            }
            if (fieldSchema.getElementType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
                typeParams.put("max_length", String.valueOf(fieldSchema.getMaxLength()));
            }
        }
        if (fieldSchema.getEnableAnalyzer() != null) {
            typeParams.put("enable_analyzer", String.valueOf(fieldSchema.getEnableAnalyzer()));
        }
        if (fieldSchema.getEnableMatch() != null) {
            typeParams.put("enable_match", String.valueOf(fieldSchema.getEnableMatch()));
        }
        if (fieldSchema.getAnalyzerParams() != null) {
            params = JsonUtils.toJson(fieldSchema.getAnalyzerParams());
            typeParams.put("analyzer_params", params);
        }
        if (fieldSchema.getMultiAnalyzerParams() != null) {
            params = JsonUtils.toJson(fieldSchema.getMultiAnalyzerParams());
            typeParams.put("multi_analyzer_params", params);
        }
        if (CollectionUtils.isNotEmpty(typeParamsList = ParamUtils.AssembleKvPair(typeParams))) {
            typeParamsList.forEach(builder::addTypeParams);
        }
        return builder.build();
    }

    public static FunctionSchema convertToGrpcFunction(CreateCollectionReq.Function function) {
        SchemaUtils.checkNullEmptyString(function.getName(), "Function name");
        FunctionSchema.Builder builder = FunctionSchema.newBuilder().setName(function.getName()).setDescription(function.getDescription()).setType(FunctionType.forNumber(function.getFunctionType().getCode()));
        for (String name : function.getInputFieldNames()) {
            builder.addInputFieldNames(name);
        }
        for (String name : function.getOutputFieldNames()) {
            builder.addOutputFieldNames(name);
        }
        return builder.build();
    }

    public static CreateCollectionReq.CollectionSchema convertFromGrpcCollectionSchema(CollectionSchema schema) {
        Object collectionSchema = ((CreateCollectionReq.CollectionSchema.CollectionSchemaBuilder)CreateCollectionReq.CollectionSchema.builder().enableDynamicField(schema.getEnableDynamicField())).build();
        ArrayList<CreateCollectionReq.FieldSchema> fieldSchemas = new ArrayList<CreateCollectionReq.FieldSchema>();
        for (FieldSchema fieldSchema : schema.getFieldsList()) {
            fieldSchemas.add(SchemaUtils.convertFromGrpcFieldSchema(fieldSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setFieldSchemaList(fieldSchemas);
        ArrayList<CreateCollectionReq.Function> functions = new ArrayList<CreateCollectionReq.Function>();
        for (FunctionSchema functionSchema : schema.getFunctionsList()) {
            functions.add(SchemaUtils.convertFromGrpcFunction(functionSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setFunctionList(functions);
        return collectionSchema;
    }

    private static CreateCollectionReq.FieldSchema convertFromGrpcFieldSchema(FieldSchema fieldSchema) {
        Object schema = ((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)CreateCollectionReq.FieldSchema.builder().name(fieldSchema.getName())).description(fieldSchema.getDescription())).dataType(DataType.valueOf(fieldSchema.getDataType().name()))).isPrimaryKey(fieldSchema.getIsPrimaryKey())).isPartitionKey(fieldSchema.getIsPartitionKey())).isClusteringKey(fieldSchema.getIsClusteringKey())).autoID(fieldSchema.getAutoID())).elementType(DataType.valueOf(fieldSchema.getElementType().name()))).isNullable(fieldSchema.getNullable())).defaultValue(ParamUtils.valueFieldToObject(fieldSchema.getDefaultValue(), fieldSchema.getDataType()))).build();
        HashMap<String, String> typeParams = new HashMap<String, String>();
        for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
            try {
                if (keyValuePair.getKey().equals("dim")) {
                    ((CreateCollectionReq.FieldSchema)schema).setDimension(Integer.parseInt(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("max_length")) {
                    ((CreateCollectionReq.FieldSchema)schema).setMaxLength(Integer.parseInt(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("max_capacity")) {
                    ((CreateCollectionReq.FieldSchema)schema).setMaxCapacity(Integer.parseInt(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("enable_analyzer")) {
                    ((CreateCollectionReq.FieldSchema)schema).setEnableAnalyzer(Boolean.parseBoolean(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("enable_match")) {
                    ((CreateCollectionReq.FieldSchema)schema).setEnableMatch(Boolean.parseBoolean(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("analyzer_params")) {
                    Map params = (Map)JsonUtils.fromJson(keyValuePair.getValue(), new TypeToken<Map<String, Object>>(){}.getType());
                    ((CreateCollectionReq.FieldSchema)schema).setAnalyzerParams(params);
                }
            }
            catch (Exception e) {
                logger.error("Failed to convert the typeParams value of {} , key:{}, value:{}", new Object[]{fieldSchema.getName(), keyValuePair.getKey(), keyValuePair.getValue()});
            }
            typeParams.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        ((CreateCollectionReq.FieldSchema)schema).setTypeParams(typeParams);
        return schema;
    }

    public static CreateCollectionReq.Function convertFromGrpcFunction(FunctionSchema functionSchema) {
        Object function = ((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)CreateCollectionReq.Function.builder().name(functionSchema.getName())).description(functionSchema.getDescription())).functionType(io.milvus.common.clientenum.FunctionType.valueOf(functionSchema.getType().name()))).inputFieldNames(functionSchema.getInputFieldNamesList().stream().collect(Collectors.toList()))).outputFieldNames(functionSchema.getOutputFieldNamesList().stream().collect(Collectors.toList()))).build();
        return function;
    }

    public static CreateCollectionReq.FieldSchema convertFieldReqToFieldSchema(AddFieldReq addFieldReq) {
        if (addFieldReq.isEnableDefaultValue() && addFieldReq.getDefaultValue() == null && addFieldReq.getIsNullable() == Boolean.FALSE) {
            String msg = String.format("Default value cannot be null for field '%s' that is defined as nullable == false.", addFieldReq.getFieldName());
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
        }
        Object fieldSchema = ((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)CreateCollectionReq.FieldSchema.builder().name(addFieldReq.getFieldName())).dataType(addFieldReq.getDataType())).description(addFieldReq.getDescription())).isPrimaryKey(addFieldReq.getIsPrimaryKey())).isPartitionKey(addFieldReq.getIsPartitionKey())).isClusteringKey(addFieldReq.getIsClusteringKey())).autoID(addFieldReq.getAutoID())).isNullable(addFieldReq.getIsNullable())).defaultValue(addFieldReq.getDefaultValue())).enableAnalyzer(addFieldReq.getEnableAnalyzer())).enableMatch(addFieldReq.getEnableMatch())).analyzerParams(addFieldReq.getAnalyzerParams())).typeParams(addFieldReq.getTypeParams())).multiAnalyzerParams(addFieldReq.getMultiAnalyzerParams())).build();
        if (addFieldReq.getDataType().equals((Object)DataType.Array)) {
            if (addFieldReq.getElementType() == null) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Element type, maxCapacity are required for array field");
            }
            ((CreateCollectionReq.FieldSchema)fieldSchema).setElementType(addFieldReq.getElementType());
            ((CreateCollectionReq.FieldSchema)fieldSchema).setMaxCapacity(addFieldReq.getMaxCapacity());
        } else if (addFieldReq.getDataType().equals((Object)DataType.VarChar)) {
            ((CreateCollectionReq.FieldSchema)fieldSchema).setMaxLength(addFieldReq.getMaxLength());
        } else if (ParamUtils.isDenseVectorDataType(io.milvus.grpc.DataType.valueOf(addFieldReq.getDataType().name()))) {
            if (addFieldReq.getDimension() == null) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Dimension is required for vector field");
            }
            ((CreateCollectionReq.FieldSchema)fieldSchema).setDimension(addFieldReq.getDimension());
        }
        return fieldSchema;
    }
}

