/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.UpsertRequest;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class DataUtils {

    public static class InsertDataInfo {
        private final CreateCollectionReq.FieldSchema field;
        private final LinkedList<Object> data;

        InsertDataInfo(CreateCollectionReq.FieldSchema field, LinkedList<Object> data) {
            this.field = field;
            this.data = data;
        }

        public static InsertDataInfoBuilder builder() {
            return new InsertDataInfoBuilder();
        }

        public CreateCollectionReq.FieldSchema getField() {
            return this.field;
        }

        public LinkedList<Object> getData() {
            return this.data;
        }

        public static class InsertDataInfoBuilder {
            private CreateCollectionReq.FieldSchema field;
            private LinkedList<Object> data;

            InsertDataInfoBuilder() {
            }

            public InsertDataInfoBuilder field(CreateCollectionReq.FieldSchema field) {
                this.field = field;
                return this;
            }

            public InsertDataInfoBuilder data(LinkedList<Object> data) {
                this.data = data;
                return this;
            }

            public InsertDataInfo build() {
                return new InsertDataInfo(this.field, this.data);
            }

            public String toString() {
                return "DataUtils.InsertDataInfo.InsertDataInfoBuilder(field=" + this.field + ", data=" + this.data + ")";
            }
        }
    }

    public static class InsertBuilderWrapper {
        private InsertRequest.Builder insertBuilder;
        private UpsertRequest.Builder upsertBuilder;

        public InsertRequest convertGrpcInsertRequest(@NonNull InsertReq requestParam, DescribeCollectionResp descColl) {
            if (requestParam == null) {
                throw new NullPointerException("requestParam is marked non-null but is null");
            }
            String dbName = requestParam.getDatabaseName();
            String collectionName = requestParam.getCollectionName();
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
            this.insertBuilder = InsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getData().size());
            if (StringUtils.isNotEmpty(dbName)) {
                this.insertBuilder.setDbName(dbName);
            }
            this.upsertBuilder = null;
            this.fillFieldsData(requestParam, descColl);
            return this.insertBuilder.build();
        }

        public UpsertRequest convertGrpcUpsertRequest(@NonNull UpsertReq requestParam, DescribeCollectionResp descColl) {
            if (requestParam == null) {
                throw new NullPointerException("requestParam is marked non-null but is null");
            }
            String dbName = requestParam.getDatabaseName();
            String collectionName = requestParam.getCollectionName();
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Upsert).build();
            this.upsertBuilder = UpsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getData().size());
            if (StringUtils.isNotEmpty(dbName)) {
                this.upsertBuilder.setDbName(dbName);
            }
            this.insertBuilder = null;
            this.fillFieldsData(requestParam, descColl);
            return this.upsertBuilder.build();
        }

        private void addFieldsData(FieldData value) {
            if (this.insertBuilder != null) {
                this.insertBuilder.addFieldsData(value);
            } else if (this.upsertBuilder != null) {
                this.upsertBuilder.addFieldsData(value);
            }
        }

        private void setPartitionName(String value) {
            if (this.insertBuilder != null) {
                this.insertBuilder.setPartitionName(value);
            } else if (this.upsertBuilder != null) {
                this.upsertBuilder.setPartitionName(value);
            }
        }

        private static boolean hasPartitionKey(DescribeCollectionResp descColl) {
            CreateCollectionReq.CollectionSchema collectionSchema = descColl.getCollectionSchema();
            List<CreateCollectionReq.FieldSchema> fieldsList = collectionSchema.getFieldSchemaList();
            for (CreateCollectionReq.FieldSchema field : fieldsList) {
                if (field.getIsPartitionKey() != Boolean.TRUE) continue;
                return true;
            }
            return false;
        }

        private void fillFieldsData(UpsertReq requestParam, DescribeCollectionResp descColl) {
            String partitionName = requestParam.getPartitionName();
            if (InsertBuilderWrapper.hasPartitionKey(descColl)) {
                if (partitionName != null && !partitionName.isEmpty()) {
                    String msg = "Collection " + requestParam.getCollectionName() + " has partition key, not allow to specify partition name";
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                }
            } else if (partitionName != null) {
                this.setPartitionName(partitionName);
            }
            List<JsonObject> rowFields = requestParam.getData();
            this.checkAndSetRowData(descColl, rowFields);
        }

        private void fillFieldsData(InsertReq requestParam, DescribeCollectionResp descColl) {
            String partitionName = requestParam.getPartitionName();
            if (InsertBuilderWrapper.hasPartitionKey(descColl)) {
                if (partitionName != null && !partitionName.isEmpty()) {
                    String msg = "Collection " + requestParam.getCollectionName() + " has partition key, not allow to specify partition name";
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                }
            } else if (partitionName != null) {
                this.setPartitionName(partitionName);
            }
            List<JsonObject> rowFields = requestParam.getData();
            this.checkAndSetRowData(descColl, rowFields);
        }

        private void checkAndSetRowData(DescribeCollectionResp descColl, List<JsonObject> rows) {
            CreateCollectionReq.CollectionSchema collectionSchema = descColl.getCollectionSchema();
            List<CreateCollectionReq.Function> functionsList = collectionSchema.getFunctionList();
            ArrayList<String> outputFieldNames = new ArrayList<String>();
            for (CreateCollectionReq.Function function : functionsList) {
                outputFieldNames.addAll(function.getOutputFieldNames());
            }
            List<CreateCollectionReq.FieldSchema> fieldsList = collectionSchema.getFieldSchemaList();
            HashMap<String, InsertDataInfo> nameInsertInfo = new HashMap<String, InsertDataInfo>();
            InsertDataInfo insertDynamicDataInfo = InsertDataInfo.builder().field((CreateCollectionReq.FieldSchema)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)CreateCollectionReq.FieldSchema.builder().name("$meta")).dataType(DataType.JSON)).build()).data(new LinkedList<Object>()).build();
            for (JsonObject row : rows) {
                for (CreateCollectionReq.FieldSchema fieldSchema : fieldsList) {
                    String msg;
                    String fieldName = fieldSchema.getName();
                    InsertDataInfo insertDataInfo = nameInsertInfo.getOrDefault(fieldName, InsertDataInfo.builder().field(fieldSchema).data(new LinkedList<Object>()).build());
                    JsonElement rowFieldData = row.get(fieldName);
                    if (rowFieldData == null) {
                        if (fieldSchema.getAutoID() == Boolean.TRUE || outputFieldNames.contains(fieldSchema.getName())) continue;
                        if (!fieldSchema.getIsNullable().booleanValue() && fieldSchema.getDefaultValue() == null) {
                            msg = String.format("The field: %s is not provided.", fieldSchema.getName());
                            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                        }
                        rowFieldData = JsonNull.INSTANCE;
                    }
                    if (fieldSchema.getAutoID() == Boolean.TRUE && this.insertBuilder != null) {
                        msg = String.format("The primary key: %s is auto generated, no need to input.", fieldName);
                        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
                    }
                    FieldSchema grpcField = SchemaUtils.convertToGrpcFieldSchema(fieldSchema);
                    Object fieldValue = ParamUtils.checkFieldValue(ParamUtils.ConvertField(grpcField), rowFieldData);
                    insertDataInfo.getData().add(fieldValue);
                    nameInsertInfo.put(fieldName, insertDataInfo);
                }
                if (!collectionSchema.isEnableDynamicField()) continue;
                JsonObject dynamicField = new JsonObject();
                for (String rowFieldName : row.keySet()) {
                    if (nameInsertInfo.containsKey(rowFieldName)) continue;
                    dynamicField.add(rowFieldName, row.get(rowFieldName));
                }
                insertDynamicDataInfo.getData().add(dynamicField);
            }
            for (String fieldNameKey : nameInsertInfo.keySet()) {
                InsertDataInfo insertDataInfo = (InsertDataInfo)nameInsertInfo.get(fieldNameKey);
                FieldSchema fieldSchema = SchemaUtils.convertToGrpcFieldSchema(insertDataInfo.getField());
                this.addFieldsData(ParamUtils.genFieldData(ParamUtils.ConvertField(fieldSchema), insertDataInfo.getData()));
            }
            if (collectionSchema.isEnableDynamicField()) {
                FieldSchema grpcField = SchemaUtils.convertToGrpcFieldSchema(insertDynamicDataInfo.getField());
                this.addFieldsData(ParamUtils.genFieldData(ParamUtils.ConvertField(grpcField), insertDynamicDataInfo.getData(), Boolean.TRUE));
            }
        }
    }
}

