/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector;

import com.google.protobuf.ByteString;
import io.milvus.common.utils.GTsDict;
import io.milvus.common.utils.JsonUtils;
import io.milvus.grpc.AnalyzerResult;
import io.milvus.grpc.AnalyzerToken;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.HybridSearchRequest;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.RunAnalyzerRequest;
import io.milvus.grpc.RunAnalyzerResponse;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.Status;
import io.milvus.grpc.UpsertRequest;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.orm.iterator.SearchIteratorV2;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.collection.CollectionService;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.RunAnalyzerReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.SearchIteratorReqV2;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.RunAnalyzerResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import io.milvus.v2.utils.DataUtils;
import io.milvus.v2.utils.VectorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorService
extends BaseService {
    Logger logger = LoggerFactory.getLogger(VectorService.class);
    public CollectionService collectionService = new CollectionService();
    private ConcurrentHashMap<String, DescribeCollectionResponse> cacheCollectionInfo = new ConcurrentHashMap();

    private DescribeCollectionResponse describeCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String databaseName, String collectionName) {
        String msg = String.format("Fail to describe collection '%s'", collectionName);
        DescribeCollectionRequest.Builder builder = DescribeCollectionRequest.newBuilder().setCollectionName(collectionName);
        if (StringUtils.isNotEmpty(databaseName)) {
            builder.setDbName(databaseName);
            msg = String.format("Fail to describe collection '%s' in database '%s'", collectionName, databaseName);
        }
        DescribeCollectionRequest describeCollectionRequest = builder.build();
        DescribeCollectionResponse response = blockingStub.describeCollection(describeCollectionRequest);
        this.rpcUtils.handleResponse(msg, response.getStatus());
        return response;
    }

    private DescribeCollectionResponse getCollectionInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String databaseName, String collectionName, boolean forceUpdate) {
        String key = GTsDict.CombineCollectionName(this.actualDbName(databaseName), collectionName);
        DescribeCollectionResponse info = this.cacheCollectionInfo.get(key);
        if (info == null || forceUpdate) {
            info = this.describeCollection(blockingStub, databaseName, collectionName);
            this.cacheCollectionInfo.put(key, info);
        }
        return info;
    }

    public void cleanCollectionCache() {
        this.cacheCollectionInfo.clear();
    }

    private void cleanCacheIfFailed(Status status, String databaseName, String collectionName) {
        if (status.getCode() != 0 && status.getCode() != 8 || !status.getErrorCode().equals(ErrorCode.Success) && status.getErrorCode() != ErrorCode.RateLimit) {
            this.removeCollectionCache(databaseName, collectionName);
        }
    }

    private void removeCollectionCache(String databaseName, String collectionName) {
        String key = GTsDict.CombineCollectionName(this.actualDbName(databaseName), collectionName);
        this.cacheCollectionInfo.remove(key);
    }

    private InsertRequest buildInsertRequest(InsertReq request, DescribeCollectionResponse descResp) {
        DataUtils.InsertBuilderWrapper requestBuilder = new DataUtils.InsertBuilderWrapper();
        DescribeCollectionResp descColl = this.convertUtils.convertDescCollectionResp(descResp);
        InsertRequest rpcRequest = requestBuilder.convertGrpcInsertRequest(request, descColl);
        return rpcRequest.toBuilder().setSchemaTimestamp(descResp.getUpdateTimestamp()).build();
    }

    public InsertResp insert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, InsertReq request) {
        InsertRequest rpcRequest;
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("InsertRequest collectionName:%s", collectionName);
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
        try {
            rpcRequest = this.buildInsertRequest(request, descResp);
        }
        catch (Exception ignored) {
            descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            rpcRequest = this.buildInsertRequest(request, descResp);
        }
        MutationResult response = blockingStub.insert(rpcRequest);
        if (response.getStatus().getErrorCode() == ErrorCode.SchemaMismatch) {
            this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            return this.insert(blockingStub, request);
        }
        this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
        this.rpcUtils.handleResponse(title, response.getStatus());
        String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
        if (response.getIDs().hasIntId()) {
            ArrayList<Object> ids = new ArrayList<Object>(response.getIDs().getIntId().getDataList());
            return ((InsertResp.InsertRespBuilder)((InsertResp.InsertRespBuilder)InsertResp.builder().InsertCnt(response.getInsertCnt())).primaryKeys(ids)).build();
        }
        ArrayList<Object> ids = new ArrayList<Object>(response.getIDs().getStrId().getDataList());
        return ((InsertResp.InsertRespBuilder)((InsertResp.InsertRespBuilder)InsertResp.builder().InsertCnt(response.getInsertCnt())).primaryKeys(ids)).build();
    }

    private UpsertRequest buildUpsertRequest(UpsertReq request, DescribeCollectionResponse descResp) {
        DataUtils.InsertBuilderWrapper requestBuilder = new DataUtils.InsertBuilderWrapper();
        DescribeCollectionResp descColl = this.convertUtils.convertDescCollectionResp(descResp);
        UpsertRequest rpcRequest = requestBuilder.convertGrpcUpsertRequest(request, descColl);
        return rpcRequest.toBuilder().setSchemaTimestamp(descResp.getUpdateTimestamp()).build();
    }

    public UpsertResp upsert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, UpsertReq request) {
        UpsertRequest rpcRequest;
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("UpsertRequest collectionName:%s", collectionName);
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
        try {
            rpcRequest = this.buildUpsertRequest(request, descResp);
        }
        catch (Exception ignored) {
            descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            rpcRequest = this.buildUpsertRequest(request, descResp);
        }
        MutationResult response = blockingStub.upsert(rpcRequest);
        if (response.getStatus().getErrorCode() == ErrorCode.SchemaMismatch) {
            this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            return this.upsert(blockingStub, request);
        }
        this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
        this.rpcUtils.handleResponse(title, response.getStatus());
        String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
        return ((UpsertResp.UpsertRespBuilder)UpsertResp.builder().upsertCnt(response.getUpsertCnt())).build();
    }

    public QueryResp query(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, QueryReq request) {
        String title = String.format("QueryRequest collectionName:%s, databaseName:%s", request.getCollectionName(), request.getDatabaseName());
        if (request.getFilter() == null && request.getIds() == null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be null at the same time");
        }
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        if (request.getIds() != null && request.getFilter() == null) {
            Object descReq = ((DescribeCollectionReq.DescribeCollectionReqBuilder)((DescribeCollectionReq.DescribeCollectionReqBuilder)DescribeCollectionReq.builder().databaseName(request.getDatabaseName())).collectionName(request.getCollectionName())).build();
            DescribeCollectionResp descResp = this.collectionService.describeCollection(blockingStub, (DescribeCollectionReq)descReq);
            request.setFilter(this.vectorUtils.getExprById(descResp.getPrimaryFieldName(), request.getIds()));
        }
        request.setDatabaseName(this.actualDbName(request.getDatabaseName()));
        QueryResults response = blockingStub.query(this.vectorUtils.ConvertToGrpcQueryRequest(request));
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((QueryResp.QueryRespBuilder)((QueryResp.QueryRespBuilder)QueryResp.builder().queryResults(this.convertUtils.getEntities(response))).sessionTs(response.getSessionTs())).build();
    }

    public SearchResp search(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchReq request) {
        String title = String.format("SearchRequest collectionName:%s, databaseName:%s", request.getCollectionName(), request.getDatabaseName());
        request.setDatabaseName(this.actualDbName(request.getDatabaseName()));
        SearchRequest searchRequest = this.vectorUtils.ConvertToGrpcSearchRequest(request);
        SearchResults response = blockingStub.search(searchRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((SearchResp.SearchRespBuilder)((SearchResp.SearchRespBuilder)((SearchResp.SearchRespBuilder)SearchResp.builder().searchResults(this.convertUtils.getEntities(response))).sessionTs(response.getSessionTs())).recalls(response.getResults().getRecallsList())).build();
    }

    public SearchResp hybridSearch(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, HybridSearchReq request) {
        String title = String.format("HybridSearchRequest collectionName:%s", request.getCollectionName());
        request.setDatabaseName(this.actualDbName(request.getDatabaseName()));
        HybridSearchRequest searchRequest = this.vectorUtils.ConvertToGrpcHybridSearchRequest(request);
        SearchResults response = blockingStub.hybridSearch(searchRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((SearchResp.SearchRespBuilder)((SearchResp.SearchRespBuilder)SearchResp.builder().searchResults(this.convertUtils.getEntities(response))).recalls(response.getResults().getRecallsList())).build();
    }

    public QueryIterator queryIterator(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, QueryIteratorReq request) {
        DescribeCollectionResponse descResp = this.describeCollection(blockingStub, request.getDatabaseName(), request.getCollectionName());
        DescribeCollectionResp respR = this.convertUtils.convertDescCollectionResp(descResp);
        CreateCollectionReq.FieldSchema pkField = respR.getCollectionSchema().getField(respR.getPrimaryFieldName());
        return new QueryIterator(request, blockingStub, pkField);
    }

    public SearchIterator searchIterator(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchIteratorReq request) {
        DescribeCollectionResponse descResp = this.describeCollection(blockingStub, request.getDatabaseName(), request.getCollectionName());
        DescribeCollectionResp respR = this.convertUtils.convertDescCollectionResp(descResp);
        CreateCollectionReq.FieldSchema pkField = respR.getCollectionSchema().getField(respR.getPrimaryFieldName());
        return new SearchIterator(request, blockingStub, pkField);
    }

    public SearchIteratorV2 searchIteratorV2(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchIteratorReqV2 request) {
        return new SearchIteratorV2(request, blockingStub);
    }

    public DeleteResp delete(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DeleteReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("DeleteRequest collectionName:%s", collectionName);
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        if (request.getFilter() == null) {
            DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
            DescribeCollectionResp respR = this.convertUtils.convertDescCollectionResp(descResp);
            request.setFilter(this.vectorUtils.getExprById(respR.getPrimaryFieldName(), request.getIds()));
        }
        DeleteRequest.Builder builder = DeleteRequest.newBuilder().setCollectionName(collectionName).setPartitionName(request.getPartitionName()).setExpr(request.getFilter());
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            Map<String, Object> filterTemplateValues = request.getFilterTemplateValues();
            filterTemplateValues.forEach((key, value) -> builder.putExprTemplateValues((String)key, VectorUtils.deduceAndCreateTemplateValue(value)));
        }
        MutationResult response = blockingStub.delete(builder.build());
        this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
        this.rpcUtils.handleResponse(title, response.getStatus());
        String key2 = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().updateCollectionTs(key2, response.getTimestamp());
        return ((DeleteResp.DeleteRespBuilder)DeleteResp.builder().deleteCnt(response.getDeleteCnt())).build();
    }

    public GetResp get(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetReq request) {
        String title = String.format("GetRequest collectionName:%s", request.getCollectionName());
        this.logger.debug(title);
        Object queryReq = ((QueryReq.QueryReqBuilder)((QueryReq.QueryReqBuilder)QueryReq.builder().collectionName(request.getCollectionName())).ids(request.getIds())).build();
        if (request.getOutputFields() != null) {
            ((QueryReq)queryReq).setOutputFields(request.getOutputFields());
        }
        QueryResp queryResp = this.query(blockingStub, (QueryReq)queryReq);
        return ((GetResp.GetRespBuilder)GetResp.builder().getResults(queryResp.getQueryResults())).build();
    }

    public RunAnalyzerResp runAnalyzer(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RunAnalyzerReq request) {
        String title = "RunAnalyzer";
        if (request.getTexts().isEmpty()) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "Texts list is empty.");
        }
        RunAnalyzerRequest.Builder builder = RunAnalyzerRequest.newBuilder();
        ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
        for (String text : request.getTexts()) {
            byteStrings.add(ByteString.copyFrom(text.getBytes()));
        }
        List<String> analyzerNames = request.getAnalyzerNames();
        builder.addAllAnalyzerNames(analyzerNames);
        String params = JsonUtils.toJson(request.getAnalyzerParams());
        System.out.println(params);
        RunAnalyzerRequest runRequest = builder.addAllPlaceholder(byteStrings).setAnalyzerParams(params).setWithDetail(request.getWithDetail()).setWithHash(request.getWithHash()).setDbName(request.getDatabaseName()).setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName()).build();
        RunAnalyzerResponse response = blockingStub.runAnalyzer(runRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<RunAnalyzerResp.AnalyzerResult> toResults = new ArrayList<RunAnalyzerResp.AnalyzerResult>();
        List<AnalyzerResult> results = response.getResultsList();
        results.forEach(item -> {
            ArrayList<RunAnalyzerResp.AnalyzerToken> toTokens = new ArrayList<RunAnalyzerResp.AnalyzerToken>();
            List<AnalyzerToken> tokens = item.getTokensList();
            tokens.forEach(token -> toTokens.add((RunAnalyzerResp.AnalyzerToken)((RunAnalyzerResp.AnalyzerToken.AnalyzerTokenBuilder)((RunAnalyzerResp.AnalyzerToken.AnalyzerTokenBuilder)((RunAnalyzerResp.AnalyzerToken.AnalyzerTokenBuilder)((RunAnalyzerResp.AnalyzerToken.AnalyzerTokenBuilder)((RunAnalyzerResp.AnalyzerToken.AnalyzerTokenBuilder)((RunAnalyzerResp.AnalyzerToken.AnalyzerTokenBuilder)RunAnalyzerResp.AnalyzerToken.builder().token(token.getToken())).startOffset(token.getStartOffset())).endOffset(token.getEndOffset())).position(token.getPosition())).positionLength(token.getPositionLength())).hash((long)token.getHash() & 0xFFFFFFFFL)).build()));
            toResults.add((RunAnalyzerResp.AnalyzerResult)((RunAnalyzerResp.AnalyzerResult.AnalyzerResultBuilder)RunAnalyzerResp.AnalyzerResult.builder().tokens(toTokens)).build());
        });
        return ((RunAnalyzerResp.RunAnalyzerRespBuilder)RunAnalyzerResp.builder().results(toResults)).build();
    }
}

