/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.database;

import io.milvus.grpc.AlterDatabaseRequest;
import io.milvus.grpc.CreateDatabaseRequest;
import io.milvus.grpc.DescribeDatabaseRequest;
import io.milvus.grpc.DescribeDatabaseResponse;
import io.milvus.grpc.DropDatabaseRequest;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.ListDatabasesRequest;
import io.milvus.grpc.ListDatabasesResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.param.ParamUtils;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.database.request.AlterDatabasePropertiesReq;
import io.milvus.v2.service.database.request.CreateDatabaseReq;
import io.milvus.v2.service.database.request.DescribeDatabaseReq;
import io.milvus.v2.service.database.request.DropDatabasePropertiesReq;
import io.milvus.v2.service.database.request.DropDatabaseReq;
import io.milvus.v2.service.database.response.DescribeDatabaseResp;
import io.milvus.v2.service.database.response.ListDatabasesResp;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DatabaseService
extends BaseService {
    public Void createDatabase(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateDatabaseReq request) {
        String title = String.format("CreateDatabaseRequest databaseName:%s", request.getDatabaseName());
        CreateDatabaseRequest.Builder builder = CreateDatabaseRequest.newBuilder().setDbName(request.getDatabaseName());
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addProperties);
        }
        Status response = blockingStub.createDatabase(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropDatabase(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropDatabaseReq request) {
        String title = String.format("DropDatabaseRequest databaseName:%s", request.getDatabaseName());
        DropDatabaseRequest rpcRequest = DropDatabaseRequest.newBuilder().setDbName(request.getDatabaseName()).build();
        Status response = blockingStub.dropDatabase(rpcRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public ListDatabasesResp listDatabases(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        ListDatabasesResponse response = blockingStub.listDatabases(ListDatabasesRequest.newBuilder().build());
        Object listDatabasesResp = ((ListDatabasesResp.ListDatabasesRespBuilder)ListDatabasesResp.builder().databaseNames(response.getDbNamesList())).build();
        return listDatabasesResp;
    }

    public Void alterDatabaseProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterDatabasePropertiesReq request) {
        String title = String.format("AlterDatabasePropertiesReq databaseName:%s", request.getDatabaseName());
        AlterDatabaseRequest.Builder builder = AlterDatabaseRequest.newBuilder().setDbName(request.getDatabaseName());
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addProperties);
        }
        Status response = blockingStub.alterDatabase(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropDatabaseProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropDatabasePropertiesReq request) {
        String title = String.format("DropDatabasePropertiesReq databaseName:%s", request.getDatabaseName());
        AlterDatabaseRequest.Builder builder = AlterDatabaseRequest.newBuilder().setDbName(request.getDatabaseName()).addAllDeleteKeys(request.getPropertyKeys());
        Status response = blockingStub.alterDatabase(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public DescribeDatabaseResp describeDatabase(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeDatabaseReq request) {
        String title = String.format("DescribeDatabaseRequest databaseName:%s", request.getDatabaseName());
        DescribeDatabaseRequest rpcRequest = DescribeDatabaseRequest.newBuilder().setDbName(request.getDatabaseName()).build();
        DescribeDatabaseResponse response = blockingStub.describeDatabase(rpcRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        HashMap<String, String> properties = new HashMap<String, String>();
        response.getPropertiesList().forEach(prop -> properties.put(prop.getKey(), prop.getValue()));
        Object describeDatabaseResp = ((DescribeDatabaseResp.DescribeDatabaseRespBuilder)((DescribeDatabaseResp.DescribeDatabaseRespBuilder)DescribeDatabaseResp.builder().databaseName(response.getDbName())).properties(properties)).build();
        return describeDatabaseResp;
    }
}

