/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.pool;

import io.milvus.pool.PoolClientFactory;
import io.milvus.pool.PoolConfig;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPool<C, T> {
    protected static final Logger logger = LoggerFactory.getLogger(ClientPool.class);
    protected GenericKeyedObjectPool<String, T> clientPool;
    protected PoolConfig config;
    protected PoolClientFactory<C, T> clientFactory;

    protected ClientPool() {
    }

    protected ClientPool(PoolConfig config, PoolClientFactory clientFactory) {
        this.config = config;
        this.clientFactory = clientFactory;
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxIdlePerKey(config.getMaxIdlePerKey());
        poolConfig.setMinIdlePerKey(config.getMinIdlePerKey());
        poolConfig.setMaxTotal(config.getMaxTotal());
        poolConfig.setMaxTotalPerKey(config.getMaxTotalPerKey());
        poolConfig.setBlockWhenExhausted(config.isBlockWhenExhausted());
        poolConfig.setMaxWait(config.getMaxBlockWaitDuration());
        poolConfig.setTestOnBorrow(config.isTestOnBorrow());
        poolConfig.setTestOnReturn(config.isTestOnReturn());
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setTimeBetweenEvictionRuns(config.getEvictionPollingInterval());
        poolConfig.setNumTestsPerEvictionRun(5);
        poolConfig.setMinEvictableIdleTime(config.getMinEvictableIdleDuration());
        this.clientPool = new GenericKeyedObjectPool(clientFactory, poolConfig);
    }

    public T getClient(String key) {
        try {
            return this.clientPool.borrowObject(key);
        }
        catch (Exception e) {
            logger.error("Failed to get client, exception: ", (Throwable)e);
            throw new MilvusClientException(ErrorCode.CLIENT_ERROR, (Throwable)e);
        }
    }

    public void returnClient(String key, T grpcClient) {
        try {
            this.clientPool.returnObject(key, grpcClient);
        }
        catch (Exception e) {
            logger.error("Failed to return client, exception: " + e);
            throw new MilvusClientException(ErrorCode.CLIENT_ERROR, (Throwable)e);
        }
    }

    public void close() {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    public void clear() {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clientPool.clear();
        }
    }

    public void clear(String key) {
        if (this.clientPool != null && !this.clientPool.isClosed()) {
            this.clientPool.clear(key);
        }
    }

    public int getIdleClientNumber(String key) {
        return this.clientPool.getNumIdle(key);
    }

    public int getActiveClientNumber(String key) {
        return this.clientPool.getNumActive(key);
    }

    public int getTotalIdleClientNumber() {
        return this.clientPool.getNumIdle();
    }

    public int getTotalActiveClientNumber() {
        return this.clientPool.getNumActive();
    }
}

