/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class GetIndexStateParam {
    private final String databaseName;
    private final String collectionName;
    private final String indexName;

    private GetIndexStateParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.indexName = builder.indexName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String toString() {
        return "GetIndexStateParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", indexName=" + this.getIndexName() + ")";
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private String indexName = "";

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withIndexName(@NonNull String indexName) {
            if (indexName == null) {
                throw new NullPointerException("indexName is marked non-null but is null");
            }
            this.indexName = indexName;
            return this;
        }

        public GetIndexStateParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.indexName == null || StringUtils.isBlank(this.indexName)) {
                this.indexName = "";
            }
            return new GetIndexStateParam(this);
        }
    }
}

