/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml.ranker;

import com.google.gson.JsonObject;
import io.milvus.common.utils.JsonUtils;
import io.milvus.exception.ParamException;
import io.milvus.param.dml.ranker.BaseRanker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class WeightedRanker
extends BaseRanker {
    private final List<Float> weights;

    private WeightedRanker(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.weights = builder.weights;
    }

    @Override
    public Map<String, String> getProperties() {
        JsonObject params = new JsonObject();
        params.add("weights", JsonUtils.toJsonTree(this.weights).getAsJsonArray());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("strategy", "weighted");
        props.put("params", params.toString());
        return props;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public String toString() {
        return "WeightedRanker(weights=" + this.getWeights() + ")";
    }

    public static class Builder {
        private List<Float> weights = new ArrayList<Float>();

        private Builder() {
        }

        public Builder withWeights(@NonNull List<Float> weights) {
            if (weights == null) {
                throw new NullPointerException("weights is marked non-null but is null");
            }
            this.weights = weights;
            return this;
        }

        public WeightedRanker build() throws ParamException {
            return new WeightedRanker(this);
        }
    }
}

