/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.MilvusException;
import io.milvus.grpc.ErrorCode;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class R<T> {
    private Exception exception;
    private Integer status;
    private T data;

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getMessage() {
        return this.exception.getMessage();
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <T> R<T> failed(Exception exception) {
        R<T> r = new R<T>();
        if (exception instanceof MilvusException) {
            MilvusException e = (MilvusException)exception;
            r.setStatus(e.getStatus());
        } else {
            r.setStatus(Status.Unknown.getCode());
        }
        r.setException(exception);
        return r;
    }

    public static <T> R<T> failed(ErrorCode errorCode, String msg) {
        R<T> r = new R<T>();
        r.setStatus(errorCode.getNumber());
        r.setException(new Exception(msg));
        return r;
    }

    public static <T> R<T> failed(Status statusCode, String msg) {
        R<T> r = new R<T>();
        r.setStatus(statusCode.getCode());
        r.setException(new Exception(msg));
        return r;
    }

    public static <T> R<T> success() {
        R<T> r = new R<T>();
        r.setStatus(Status.Success.getCode());
        return r;
    }

    public static <T> R<T> success(T data) {
        R<T> r = new R<T>();
        r.setStatus(Status.Success.getCode());
        r.setData(data);
        return r;
    }

    public String toString() {
        if (this.exception != null) {
            return "R{exception=" + ExceptionUtils.getMessage(this.exception) + ", status=" + this.status + ", data=" + this.data + '}';
        }
        return "R{status=" + this.status + ", data=" + this.data + '}';
    }

    public static enum Status {
        Success(0),
        UnexpectedError(1),
        ConnectFailed(2),
        PermissionDenied(3),
        CollectionNotExists(4),
        IllegalArgument(5),
        IllegalDimension(7),
        IllegalIndexType(8),
        IllegalCollectionName(9),
        IllegalTOPK(10),
        IllegalRowRecord(11),
        IllegalVectorID(12),
        IllegalSearchResult(13),
        FileNotFound(14),
        MetaFailed(15),
        CacheFailed(16),
        CannotCreateFolder(17),
        CannotCreateFile(18),
        CannotDeleteFolder(19),
        CannotDeleteFile(20),
        BuildIndexError(21),
        IllegalNLIST(22),
        IllegalMetricType(23),
        OutOfMemory(24),
        IndexNotExist(25),
        EmptyCollection(26),
        DDRequestRace(1000),
        RpcError(-1),
        ClientNotConnected(-2),
        Unknown(-3),
        VersionMismatch(-4),
        ParamError(-5),
        IllegalResponse(-6);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public static Status valueOf(int val) {
            Optional<Status> search = Arrays.stream(Status.values()).filter(status -> status.code == val).findFirst();
            return search.orElse(Unknown);
        }

        public int getCode() {
            return this.code;
        }
    }
}

