/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.grpc;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.milvus.grpc.ConsistencyLevel;
import io.milvus.grpc.HybridSearchRequestOrBuilder;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.KeyValuePairOrBuilder;
import io.milvus.grpc.MilvusProto;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgBaseOrBuilder;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchRequestOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HybridSearchRequest
extends GeneratedMessageV3
implements HybridSearchRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int BASE_FIELD_NUMBER = 1;
    private MsgBase base_;
    public static final int DB_NAME_FIELD_NUMBER = 2;
    private volatile Object dbName_ = "";
    public static final int COLLECTION_NAME_FIELD_NUMBER = 3;
    private volatile Object collectionName_ = "";
    public static final int PARTITION_NAMES_FIELD_NUMBER = 4;
    private LazyStringArrayList partitionNames_ = LazyStringArrayList.emptyList();
    public static final int REQUESTS_FIELD_NUMBER = 5;
    private List<SearchRequest> requests_;
    public static final int RANK_PARAMS_FIELD_NUMBER = 6;
    private List<KeyValuePair> rankParams_;
    public static final int TRAVEL_TIMESTAMP_FIELD_NUMBER = 7;
    private long travelTimestamp_ = 0L;
    public static final int GUARANTEE_TIMESTAMP_FIELD_NUMBER = 8;
    private long guaranteeTimestamp_ = 0L;
    public static final int NOT_RETURN_ALL_META_FIELD_NUMBER = 9;
    private boolean notReturnAllMeta_ = false;
    public static final int OUTPUT_FIELDS_FIELD_NUMBER = 10;
    private LazyStringArrayList outputFields_ = LazyStringArrayList.emptyList();
    public static final int CONSISTENCY_LEVEL_FIELD_NUMBER = 11;
    private int consistencyLevel_ = 0;
    public static final int USE_DEFAULT_CONSISTENCY_FIELD_NUMBER = 12;
    private boolean useDefaultConsistency_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final HybridSearchRequest DEFAULT_INSTANCE = new HybridSearchRequest();
    private static final Parser<HybridSearchRequest> PARSER = new AbstractParser<HybridSearchRequest>(){

        @Override
        public HybridSearchRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = HybridSearchRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private HybridSearchRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private HybridSearchRequest() {
        this.dbName_ = "";
        this.collectionName_ = "";
        this.partitionNames_ = LazyStringArrayList.emptyList();
        this.requests_ = Collections.emptyList();
        this.rankParams_ = Collections.emptyList();
        this.outputFields_ = LazyStringArrayList.emptyList();
        this.consistencyLevel_ = 0;
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new HybridSearchRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MilvusProto.internal_static_milvus_proto_milvus_HybridSearchRequest_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MilvusProto.internal_static_milvus_proto_milvus_HybridSearchRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(HybridSearchRequest.class, Builder.class);
    }

    @Override
    public boolean hasBase() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public MsgBase getBase() {
        return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
    }

    @Override
    public MsgBaseOrBuilder getBaseOrBuilder() {
        return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
    }

    @Override
    public String getDbName() {
        Object ref = this.dbName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.dbName_ = s2;
        return s2;
    }

    @Override
    public ByteString getDbNameBytes() {
        Object ref = this.dbName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.dbName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getCollectionName() {
        Object ref = this.collectionName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.collectionName_ = s2;
        return s2;
    }

    @Override
    public ByteString getCollectionNameBytes() {
        Object ref = this.collectionName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.collectionName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getPartitionNamesList() {
        return this.partitionNames_;
    }

    @Override
    public int getPartitionNamesCount() {
        return this.partitionNames_.size();
    }

    @Override
    public String getPartitionNames(int index) {
        return this.partitionNames_.get(index);
    }

    @Override
    public ByteString getPartitionNamesBytes(int index) {
        return this.partitionNames_.getByteString(index);
    }

    @Override
    public List<SearchRequest> getRequestsList() {
        return this.requests_;
    }

    @Override
    public List<? extends SearchRequestOrBuilder> getRequestsOrBuilderList() {
        return this.requests_;
    }

    @Override
    public int getRequestsCount() {
        return this.requests_.size();
    }

    @Override
    public SearchRequest getRequests(int index) {
        return this.requests_.get(index);
    }

    @Override
    public SearchRequestOrBuilder getRequestsOrBuilder(int index) {
        return this.requests_.get(index);
    }

    @Override
    public List<KeyValuePair> getRankParamsList() {
        return this.rankParams_;
    }

    @Override
    public List<? extends KeyValuePairOrBuilder> getRankParamsOrBuilderList() {
        return this.rankParams_;
    }

    @Override
    public int getRankParamsCount() {
        return this.rankParams_.size();
    }

    @Override
    public KeyValuePair getRankParams(int index) {
        return this.rankParams_.get(index);
    }

    @Override
    public KeyValuePairOrBuilder getRankParamsOrBuilder(int index) {
        return this.rankParams_.get(index);
    }

    @Override
    public long getTravelTimestamp() {
        return this.travelTimestamp_;
    }

    @Override
    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp_;
    }

    @Override
    public boolean getNotReturnAllMeta() {
        return this.notReturnAllMeta_;
    }

    public ProtocolStringList getOutputFieldsList() {
        return this.outputFields_;
    }

    @Override
    public int getOutputFieldsCount() {
        return this.outputFields_.size();
    }

    @Override
    public String getOutputFields(int index) {
        return this.outputFields_.get(index);
    }

    @Override
    public ByteString getOutputFieldsBytes(int index) {
        return this.outputFields_.getByteString(index);
    }

    @Override
    public int getConsistencyLevelValue() {
        return this.consistencyLevel_;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        ConsistencyLevel result = ConsistencyLevel.forNumber(this.consistencyLevel_);
        return result == null ? ConsistencyLevel.UNRECOGNIZED : result;
    }

    @Override
    public boolean getUseDefaultConsistency() {
        return this.useDefaultConsistency_;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, this.getBase());
        }
        if (!GeneratedMessageV3.isStringEmpty(this.dbName_)) {
            GeneratedMessageV3.writeString(output, 2, this.dbName_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.collectionName_)) {
            GeneratedMessageV3.writeString(output, 3, this.collectionName_);
        }
        for (i = 0; i < this.partitionNames_.size(); ++i) {
            GeneratedMessageV3.writeString(output, 4, this.partitionNames_.getRaw(i));
        }
        for (i = 0; i < this.requests_.size(); ++i) {
            output.writeMessage(5, this.requests_.get(i));
        }
        for (i = 0; i < this.rankParams_.size(); ++i) {
            output.writeMessage(6, this.rankParams_.get(i));
        }
        if (this.travelTimestamp_ != 0L) {
            output.writeUInt64(7, this.travelTimestamp_);
        }
        if (this.guaranteeTimestamp_ != 0L) {
            output.writeUInt64(8, this.guaranteeTimestamp_);
        }
        if (this.notReturnAllMeta_) {
            output.writeBool(9, this.notReturnAllMeta_);
        }
        for (i = 0; i < this.outputFields_.size(); ++i) {
            GeneratedMessageV3.writeString(output, 10, this.outputFields_.getRaw(i));
        }
        if (this.consistencyLevel_ != ConsistencyLevel.Strong.getNumber()) {
            output.writeEnum(11, this.consistencyLevel_);
        }
        if (this.useDefaultConsistency_) {
            output.writeBool(12, this.useDefaultConsistency_);
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize(1, this.getBase());
        }
        if (!GeneratedMessageV3.isStringEmpty(this.dbName_)) {
            size += GeneratedMessageV3.computeStringSize(2, this.dbName_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.collectionName_)) {
            size += GeneratedMessageV3.computeStringSize(3, this.collectionName_);
        }
        int dataSize = 0;
        for (i2 = 0; i2 < this.partitionNames_.size(); ++i2) {
            dataSize += HybridSearchRequest.computeStringSizeNoTag(this.partitionNames_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getPartitionNamesList().size();
        for (i = 0; i < this.requests_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(5, this.requests_.get(i));
        }
        for (i = 0; i < this.rankParams_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(6, this.rankParams_.get(i));
        }
        if (this.travelTimestamp_ != 0L) {
            size += CodedOutputStream.computeUInt64Size(7, this.travelTimestamp_);
        }
        if (this.guaranteeTimestamp_ != 0L) {
            size += CodedOutputStream.computeUInt64Size(8, this.guaranteeTimestamp_);
        }
        if (this.notReturnAllMeta_) {
            size += CodedOutputStream.computeBoolSize(9, this.notReturnAllMeta_);
        }
        dataSize = 0;
        for (i2 = 0; i2 < this.outputFields_.size(); ++i2) {
            dataSize += HybridSearchRequest.computeStringSizeNoTag(this.outputFields_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getOutputFieldsList().size();
        if (this.consistencyLevel_ != ConsistencyLevel.Strong.getNumber()) {
            size += CodedOutputStream.computeEnumSize(11, this.consistencyLevel_);
        }
        if (this.useDefaultConsistency_) {
            size += CodedOutputStream.computeBoolSize(12, this.useDefaultConsistency_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HybridSearchRequest)) {
            return super.equals(obj);
        }
        HybridSearchRequest other = (HybridSearchRequest)obj;
        if (this.hasBase() != other.hasBase()) {
            return false;
        }
        if (this.hasBase() && !this.getBase().equals(other.getBase())) {
            return false;
        }
        if (!this.getDbName().equals(other.getDbName())) {
            return false;
        }
        if (!this.getCollectionName().equals(other.getCollectionName())) {
            return false;
        }
        if (!this.getPartitionNamesList().equals(other.getPartitionNamesList())) {
            return false;
        }
        if (!this.getRequestsList().equals(other.getRequestsList())) {
            return false;
        }
        if (!this.getRankParamsList().equals(other.getRankParamsList())) {
            return false;
        }
        if (this.getTravelTimestamp() != other.getTravelTimestamp()) {
            return false;
        }
        if (this.getGuaranteeTimestamp() != other.getGuaranteeTimestamp()) {
            return false;
        }
        if (this.getNotReturnAllMeta() != other.getNotReturnAllMeta()) {
            return false;
        }
        if (!this.getOutputFieldsList().equals(other.getOutputFieldsList())) {
            return false;
        }
        if (this.consistencyLevel_ != other.consistencyLevel_) {
            return false;
        }
        if (this.getUseDefaultConsistency() != other.getUseDefaultConsistency()) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + HybridSearchRequest.getDescriptor().hashCode();
        if (this.hasBase()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getBase().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDbName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getCollectionName().hashCode();
        if (this.getPartitionNamesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getPartitionNamesList().hashCode();
        }
        if (this.getRequestsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getRequestsList().hashCode();
        }
        if (this.getRankParamsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getRankParamsList().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong(this.getTravelTimestamp());
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashLong(this.getGuaranteeTimestamp());
        hash = 37 * hash + 9;
        hash = 53 * hash + Internal.hashBoolean(this.getNotReturnAllMeta());
        if (this.getOutputFieldsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getOutputFieldsList().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.consistencyLevel_;
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean(this.getUseDefaultConsistency());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static HybridSearchRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static HybridSearchRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static HybridSearchRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static HybridSearchRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static HybridSearchRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static HybridSearchRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static HybridSearchRequest parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static HybridSearchRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static HybridSearchRequest parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static HybridSearchRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static HybridSearchRequest parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static HybridSearchRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return HybridSearchRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HybridSearchRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static HybridSearchRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<HybridSearchRequest> parser() {
        return PARSER;
    }

    public Parser<HybridSearchRequest> getParserForType() {
        return PARSER;
    }

    @Override
    public HybridSearchRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements HybridSearchRequestOrBuilder {
        private int bitField0_;
        private MsgBase base_;
        private SingleFieldBuilderV3<MsgBase, MsgBase.Builder, MsgBaseOrBuilder> baseBuilder_;
        private Object dbName_ = "";
        private Object collectionName_ = "";
        private LazyStringArrayList partitionNames_ = LazyStringArrayList.emptyList();
        private List<SearchRequest> requests_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<SearchRequest, SearchRequest.Builder, SearchRequestOrBuilder> requestsBuilder_;
        private List<KeyValuePair> rankParams_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> rankParamsBuilder_;
        private long travelTimestamp_;
        private long guaranteeTimestamp_;
        private boolean notReturnAllMeta_;
        private LazyStringArrayList outputFields_ = LazyStringArrayList.emptyList();
        private int consistencyLevel_ = 0;
        private boolean useDefaultConsistency_;

        public static final Descriptors.Descriptor getDescriptor() {
            return MilvusProto.internal_static_milvus_proto_milvus_HybridSearchRequest_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MilvusProto.internal_static_milvus_proto_milvus_HybridSearchRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(HybridSearchRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getBaseFieldBuilder();
                this.getRequestsFieldBuilder();
                this.getRankParamsFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.base_ = null;
            if (this.baseBuilder_ != null) {
                this.baseBuilder_.dispose();
                this.baseBuilder_ = null;
            }
            this.dbName_ = "";
            this.collectionName_ = "";
            this.partitionNames_ = LazyStringArrayList.emptyList();
            if (this.requestsBuilder_ == null) {
                this.requests_ = Collections.emptyList();
            } else {
                this.requests_ = null;
                this.requestsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            if (this.rankParamsBuilder_ == null) {
                this.rankParams_ = Collections.emptyList();
            } else {
                this.rankParams_ = null;
                this.rankParamsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.travelTimestamp_ = 0L;
            this.guaranteeTimestamp_ = 0L;
            this.notReturnAllMeta_ = false;
            this.outputFields_ = LazyStringArrayList.emptyList();
            this.consistencyLevel_ = 0;
            this.useDefaultConsistency_ = false;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return MilvusProto.internal_static_milvus_proto_milvus_HybridSearchRequest_descriptor;
        }

        @Override
        public HybridSearchRequest getDefaultInstanceForType() {
            return HybridSearchRequest.getDefaultInstance();
        }

        @Override
        public HybridSearchRequest build() {
            HybridSearchRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public HybridSearchRequest buildPartial() {
            HybridSearchRequest result = new HybridSearchRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(HybridSearchRequest result) {
            if (this.requestsBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.requests_ = Collections.unmodifiableList(this.requests_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.requests_ = this.requests_;
            } else {
                result.requests_ = this.requestsBuilder_.build();
            }
            if (this.rankParamsBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.rankParams_ = Collections.unmodifiableList(this.rankParams_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.rankParams_ = this.rankParams_;
            } else {
                result.rankParams_ = this.rankParamsBuilder_.build();
            }
        }

        private void buildPartial0(HybridSearchRequest result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.base_ = this.baseBuilder_ == null ? this.base_ : this.baseBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.dbName_ = this.dbName_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.collectionName_ = this.collectionName_;
            }
            if ((from_bitField0_ & 8) != 0) {
                this.partitionNames_.makeImmutable();
                result.partitionNames_ = this.partitionNames_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.travelTimestamp_ = this.travelTimestamp_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.guaranteeTimestamp_ = this.guaranteeTimestamp_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.notReturnAllMeta_ = this.notReturnAllMeta_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                this.outputFields_.makeImmutable();
                result.outputFields_ = this.outputFields_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.consistencyLevel_ = this.consistencyLevel_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.useDefaultConsistency_ = this.useDefaultConsistency_;
            }
            HybridSearchRequest hybridSearchRequest = result;
            hybridSearchRequest.bitField0_ = hybridSearchRequest.bitField0_ | to_bitField0_;
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof HybridSearchRequest) {
                return this.mergeFrom((HybridSearchRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(HybridSearchRequest other) {
            if (other == HybridSearchRequest.getDefaultInstance()) {
                return this;
            }
            if (other.hasBase()) {
                this.mergeBase(other.getBase());
            }
            if (!other.getDbName().isEmpty()) {
                this.dbName_ = other.dbName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getCollectionName().isEmpty()) {
                this.collectionName_ = other.collectionName_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.partitionNames_.isEmpty()) {
                if (this.partitionNames_.isEmpty()) {
                    this.partitionNames_ = other.partitionNames_;
                    this.bitField0_ |= 8;
                } else {
                    this.ensurePartitionNamesIsMutable();
                    this.partitionNames_.addAll(other.partitionNames_);
                }
                this.onChanged();
            }
            if (this.requestsBuilder_ == null) {
                if (!other.requests_.isEmpty()) {
                    if (this.requests_.isEmpty()) {
                        this.requests_ = other.requests_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensureRequestsIsMutable();
                        this.requests_.addAll(other.requests_);
                    }
                    this.onChanged();
                }
            } else if (!other.requests_.isEmpty()) {
                if (this.requestsBuilder_.isEmpty()) {
                    this.requestsBuilder_.dispose();
                    this.requestsBuilder_ = null;
                    this.requests_ = other.requests_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.requestsBuilder_ = alwaysUseFieldBuilders ? this.getRequestsFieldBuilder() : null;
                } else {
                    this.requestsBuilder_.addAllMessages(other.requests_);
                }
            }
            if (this.rankParamsBuilder_ == null) {
                if (!other.rankParams_.isEmpty()) {
                    if (this.rankParams_.isEmpty()) {
                        this.rankParams_ = other.rankParams_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureRankParamsIsMutable();
                        this.rankParams_.addAll(other.rankParams_);
                    }
                    this.onChanged();
                }
            } else if (!other.rankParams_.isEmpty()) {
                if (this.rankParamsBuilder_.isEmpty()) {
                    this.rankParamsBuilder_.dispose();
                    this.rankParamsBuilder_ = null;
                    this.rankParams_ = other.rankParams_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.rankParamsBuilder_ = alwaysUseFieldBuilders ? this.getRankParamsFieldBuilder() : null;
                } else {
                    this.rankParamsBuilder_.addAllMessages(other.rankParams_);
                }
            }
            if (other.getTravelTimestamp() != 0L) {
                this.setTravelTimestamp(other.getTravelTimestamp());
            }
            if (other.getGuaranteeTimestamp() != 0L) {
                this.setGuaranteeTimestamp(other.getGuaranteeTimestamp());
            }
            if (other.getNotReturnAllMeta()) {
                this.setNotReturnAllMeta(other.getNotReturnAllMeta());
            }
            if (!other.outputFields_.isEmpty()) {
                if (this.outputFields_.isEmpty()) {
                    this.outputFields_ = other.outputFields_;
                    this.bitField0_ |= 0x200;
                } else {
                    this.ensureOutputFieldsIsMutable();
                    this.outputFields_.addAll(other.outputFields_);
                }
                this.onChanged();
            }
            if (other.consistencyLevel_ != 0) {
                this.setConsistencyLevelValue(other.getConsistencyLevelValue());
            }
            if (other.getUseDefaultConsistency()) {
                this.setUseDefaultConsistency(other.getUseDefaultConsistency());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            input.readMessage(this.getBaseFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 18: {
                            this.dbName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block20;
                        }
                        case 26: {
                            this.collectionName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 34: {
                            String s2 = input.readStringRequireUtf8();
                            this.ensurePartitionNamesIsMutable();
                            this.partitionNames_.add(s2);
                            continue block20;
                        }
                        case 42: {
                            GeneratedMessageV3 m3 = input.readMessage(SearchRequest.parser(), extensionRegistry);
                            if (this.requestsBuilder_ == null) {
                                this.ensureRequestsIsMutable();
                                this.requests_.add((SearchRequest)m3);
                                continue block20;
                            }
                            this.requestsBuilder_.addMessage((SearchRequest)m3);
                            continue block20;
                        }
                        case 50: {
                            GeneratedMessageV3 m3 = input.readMessage(KeyValuePair.parser(), extensionRegistry);
                            if (this.rankParamsBuilder_ == null) {
                                this.ensureRankParamsIsMutable();
                                this.rankParams_.add((KeyValuePair)m3);
                                continue block20;
                            }
                            this.rankParamsBuilder_.addMessage((KeyValuePair)m3);
                            continue block20;
                        }
                        case 56: {
                            this.travelTimestamp_ = input.readUInt64();
                            this.bitField0_ |= 0x40;
                            continue block20;
                        }
                        case 64: {
                            this.guaranteeTimestamp_ = input.readUInt64();
                            this.bitField0_ |= 0x80;
                            continue block20;
                        }
                        case 72: {
                            this.notReturnAllMeta_ = input.readBool();
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 82: {
                            String s2 = input.readStringRequireUtf8();
                            this.ensureOutputFieldsIsMutable();
                            this.outputFields_.add(s2);
                            continue block20;
                        }
                        case 88: {
                            this.consistencyLevel_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block20;
                        }
                        case 96: {
                            this.useDefaultConsistency_ = input.readBool();
                            this.bitField0_ |= 0x800;
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasBase() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public MsgBase getBase() {
            if (this.baseBuilder_ == null) {
                return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
            }
            return this.baseBuilder_.getMessage();
        }

        public Builder setBase(MsgBase value) {
            if (this.baseBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.base_ = value;
            } else {
                this.baseBuilder_.setMessage(value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setBase(MsgBase.Builder builderForValue) {
            if (this.baseBuilder_ == null) {
                this.base_ = builderForValue.build();
            } else {
                this.baseBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeBase(MsgBase value) {
            if (this.baseBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.base_ != null && this.base_ != MsgBase.getDefaultInstance()) {
                    this.getBaseBuilder().mergeFrom(value);
                } else {
                    this.base_ = value;
                }
            } else {
                this.baseBuilder_.mergeFrom(value);
            }
            if (this.base_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearBase() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.base_ = null;
            if (this.baseBuilder_ != null) {
                this.baseBuilder_.dispose();
                this.baseBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MsgBase.Builder getBaseBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return this.getBaseFieldBuilder().getBuilder();
        }

        @Override
        public MsgBaseOrBuilder getBaseOrBuilder() {
            if (this.baseBuilder_ != null) {
                return this.baseBuilder_.getMessageOrBuilder();
            }
            return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
        }

        private SingleFieldBuilderV3<MsgBase, MsgBase.Builder, MsgBaseOrBuilder> getBaseFieldBuilder() {
            if (this.baseBuilder_ == null) {
                this.baseBuilder_ = new SingleFieldBuilderV3(this.getBase(), this.getParentForChildren(), this.isClean());
                this.base_ = null;
            }
            return this.baseBuilder_;
        }

        @Override
        public String getDbName() {
            Object ref = this.dbName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.dbName_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDbNameBytes() {
            Object ref = this.dbName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.dbName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDbName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dbName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearDbName() {
            this.dbName_ = HybridSearchRequest.getDefaultInstance().getDbName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setDbNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridSearchRequest.checkByteStringIsUtf8(value);
            this.dbName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getCollectionName() {
            Object ref = this.collectionName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.collectionName_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCollectionNameBytes() {
            Object ref = this.collectionName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.collectionName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCollectionName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.collectionName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearCollectionName() {
            this.collectionName_ = HybridSearchRequest.getDefaultInstance().getCollectionName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setCollectionNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridSearchRequest.checkByteStringIsUtf8(value);
            this.collectionName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensurePartitionNamesIsMutable() {
            if (!this.partitionNames_.isModifiable()) {
                this.partitionNames_ = new LazyStringArrayList(this.partitionNames_);
            }
            this.bitField0_ |= 8;
        }

        public ProtocolStringList getPartitionNamesList() {
            this.partitionNames_.makeImmutable();
            return this.partitionNames_;
        }

        @Override
        public int getPartitionNamesCount() {
            return this.partitionNames_.size();
        }

        @Override
        public String getPartitionNames(int index) {
            return this.partitionNames_.get(index);
        }

        @Override
        public ByteString getPartitionNamesBytes(int index) {
            return this.partitionNames_.getByteString(index);
        }

        public Builder setPartitionNames(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePartitionNamesIsMutable();
            this.partitionNames_.set(index, value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addPartitionNames(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePartitionNamesIsMutable();
            this.partitionNames_.add(value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAllPartitionNames(Iterable<String> values2) {
            this.ensurePartitionNamesIsMutable();
            AbstractMessageLite.Builder.addAll(values2, this.partitionNames_);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearPartitionNames() {
            this.partitionNames_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addPartitionNamesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridSearchRequest.checkByteStringIsUtf8(value);
            this.ensurePartitionNamesIsMutable();
            this.partitionNames_.add(value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensureRequestsIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.requests_ = new ArrayList<SearchRequest>(this.requests_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<SearchRequest> getRequestsList() {
            if (this.requestsBuilder_ == null) {
                return Collections.unmodifiableList(this.requests_);
            }
            return this.requestsBuilder_.getMessageList();
        }

        @Override
        public int getRequestsCount() {
            if (this.requestsBuilder_ == null) {
                return this.requests_.size();
            }
            return this.requestsBuilder_.getCount();
        }

        @Override
        public SearchRequest getRequests(int index) {
            if (this.requestsBuilder_ == null) {
                return this.requests_.get(index);
            }
            return this.requestsBuilder_.getMessage(index);
        }

        public Builder setRequests(int index, SearchRequest value) {
            if (this.requestsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequestsIsMutable();
                this.requests_.set(index, value);
                this.onChanged();
            } else {
                this.requestsBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setRequests(int index, SearchRequest.Builder builderForValue) {
            if (this.requestsBuilder_ == null) {
                this.ensureRequestsIsMutable();
                this.requests_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requestsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addRequests(SearchRequest value) {
            if (this.requestsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequestsIsMutable();
                this.requests_.add(value);
                this.onChanged();
            } else {
                this.requestsBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addRequests(int index, SearchRequest value) {
            if (this.requestsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRequestsIsMutable();
                this.requests_.add(index, value);
                this.onChanged();
            } else {
                this.requestsBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addRequests(SearchRequest.Builder builderForValue) {
            if (this.requestsBuilder_ == null) {
                this.ensureRequestsIsMutable();
                this.requests_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.requestsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addRequests(int index, SearchRequest.Builder builderForValue) {
            if (this.requestsBuilder_ == null) {
                this.ensureRequestsIsMutable();
                this.requests_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.requestsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllRequests(Iterable<? extends SearchRequest> values2) {
            if (this.requestsBuilder_ == null) {
                this.ensureRequestsIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.requests_);
                this.onChanged();
            } else {
                this.requestsBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearRequests() {
            if (this.requestsBuilder_ == null) {
                this.requests_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.requestsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRequests(int index) {
            if (this.requestsBuilder_ == null) {
                this.ensureRequestsIsMutable();
                this.requests_.remove(index);
                this.onChanged();
            } else {
                this.requestsBuilder_.remove(index);
            }
            return this;
        }

        public SearchRequest.Builder getRequestsBuilder(int index) {
            return this.getRequestsFieldBuilder().getBuilder(index);
        }

        @Override
        public SearchRequestOrBuilder getRequestsOrBuilder(int index) {
            if (this.requestsBuilder_ == null) {
                return this.requests_.get(index);
            }
            return this.requestsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends SearchRequestOrBuilder> getRequestsOrBuilderList() {
            if (this.requestsBuilder_ != null) {
                return this.requestsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.requests_);
        }

        public SearchRequest.Builder addRequestsBuilder() {
            return this.getRequestsFieldBuilder().addBuilder(SearchRequest.getDefaultInstance());
        }

        public SearchRequest.Builder addRequestsBuilder(int index) {
            return this.getRequestsFieldBuilder().addBuilder(index, SearchRequest.getDefaultInstance());
        }

        public List<SearchRequest.Builder> getRequestsBuilderList() {
            return this.getRequestsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<SearchRequest, SearchRequest.Builder, SearchRequestOrBuilder> getRequestsFieldBuilder() {
            if (this.requestsBuilder_ == null) {
                this.requestsBuilder_ = new RepeatedFieldBuilderV3(this.requests_, (this.bitField0_ & 0x10) != 0, this.getParentForChildren(), this.isClean());
                this.requests_ = null;
            }
            return this.requestsBuilder_;
        }

        private void ensureRankParamsIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.rankParams_ = new ArrayList<KeyValuePair>(this.rankParams_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<KeyValuePair> getRankParamsList() {
            if (this.rankParamsBuilder_ == null) {
                return Collections.unmodifiableList(this.rankParams_);
            }
            return this.rankParamsBuilder_.getMessageList();
        }

        @Override
        public int getRankParamsCount() {
            if (this.rankParamsBuilder_ == null) {
                return this.rankParams_.size();
            }
            return this.rankParamsBuilder_.getCount();
        }

        @Override
        public KeyValuePair getRankParams(int index) {
            if (this.rankParamsBuilder_ == null) {
                return this.rankParams_.get(index);
            }
            return this.rankParamsBuilder_.getMessage(index);
        }

        public Builder setRankParams(int index, KeyValuePair value) {
            if (this.rankParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRankParamsIsMutable();
                this.rankParams_.set(index, value);
                this.onChanged();
            } else {
                this.rankParamsBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setRankParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.rankParamsBuilder_ == null) {
                this.ensureRankParamsIsMutable();
                this.rankParams_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.rankParamsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addRankParams(KeyValuePair value) {
            if (this.rankParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRankParamsIsMutable();
                this.rankParams_.add(value);
                this.onChanged();
            } else {
                this.rankParamsBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addRankParams(int index, KeyValuePair value) {
            if (this.rankParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRankParamsIsMutable();
                this.rankParams_.add(index, value);
                this.onChanged();
            } else {
                this.rankParamsBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addRankParams(KeyValuePair.Builder builderForValue) {
            if (this.rankParamsBuilder_ == null) {
                this.ensureRankParamsIsMutable();
                this.rankParams_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.rankParamsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addRankParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.rankParamsBuilder_ == null) {
                this.ensureRankParamsIsMutable();
                this.rankParams_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.rankParamsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllRankParams(Iterable<? extends KeyValuePair> values2) {
            if (this.rankParamsBuilder_ == null) {
                this.ensureRankParamsIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.rankParams_);
                this.onChanged();
            } else {
                this.rankParamsBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearRankParams() {
            if (this.rankParamsBuilder_ == null) {
                this.rankParams_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.rankParamsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRankParams(int index) {
            if (this.rankParamsBuilder_ == null) {
                this.ensureRankParamsIsMutable();
                this.rankParams_.remove(index);
                this.onChanged();
            } else {
                this.rankParamsBuilder_.remove(index);
            }
            return this;
        }

        public KeyValuePair.Builder getRankParamsBuilder(int index) {
            return this.getRankParamsFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValuePairOrBuilder getRankParamsOrBuilder(int index) {
            if (this.rankParamsBuilder_ == null) {
                return this.rankParams_.get(index);
            }
            return this.rankParamsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValuePairOrBuilder> getRankParamsOrBuilderList() {
            if (this.rankParamsBuilder_ != null) {
                return this.rankParamsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.rankParams_);
        }

        public KeyValuePair.Builder addRankParamsBuilder() {
            return this.getRankParamsFieldBuilder().addBuilder(KeyValuePair.getDefaultInstance());
        }

        public KeyValuePair.Builder addRankParamsBuilder(int index) {
            return this.getRankParamsFieldBuilder().addBuilder(index, KeyValuePair.getDefaultInstance());
        }

        public List<KeyValuePair.Builder> getRankParamsBuilderList() {
            return this.getRankParamsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> getRankParamsFieldBuilder() {
            if (this.rankParamsBuilder_ == null) {
                this.rankParamsBuilder_ = new RepeatedFieldBuilderV3(this.rankParams_, (this.bitField0_ & 0x20) != 0, this.getParentForChildren(), this.isClean());
                this.rankParams_ = null;
            }
            return this.rankParamsBuilder_;
        }

        @Override
        public long getTravelTimestamp() {
            return this.travelTimestamp_;
        }

        public Builder setTravelTimestamp(long value) {
            this.travelTimestamp_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearTravelTimestamp() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.travelTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getGuaranteeTimestamp() {
            return this.guaranteeTimestamp_;
        }

        public Builder setGuaranteeTimestamp(long value) {
            this.guaranteeTimestamp_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearGuaranteeTimestamp() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.guaranteeTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getNotReturnAllMeta() {
            return this.notReturnAllMeta_;
        }

        public Builder setNotReturnAllMeta(boolean value) {
            this.notReturnAllMeta_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearNotReturnAllMeta() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.notReturnAllMeta_ = false;
            this.onChanged();
            return this;
        }

        private void ensureOutputFieldsIsMutable() {
            if (!this.outputFields_.isModifiable()) {
                this.outputFields_ = new LazyStringArrayList(this.outputFields_);
            }
            this.bitField0_ |= 0x200;
        }

        public ProtocolStringList getOutputFieldsList() {
            this.outputFields_.makeImmutable();
            return this.outputFields_;
        }

        @Override
        public int getOutputFieldsCount() {
            return this.outputFields_.size();
        }

        @Override
        public String getOutputFields(int index) {
            return this.outputFields_.get(index);
        }

        @Override
        public ByteString getOutputFieldsBytes(int index) {
            return this.outputFields_.getByteString(index);
        }

        public Builder setOutputFields(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureOutputFieldsIsMutable();
            this.outputFields_.set(index, value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addOutputFields(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureOutputFieldsIsMutable();
            this.outputFields_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addAllOutputFields(Iterable<String> values2) {
            this.ensureOutputFieldsIsMutable();
            AbstractMessageLite.Builder.addAll(values2, this.outputFields_);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearOutputFields() {
            this.outputFields_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder addOutputFieldsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridSearchRequest.checkByteStringIsUtf8(value);
            this.ensureOutputFieldsIsMutable();
            this.outputFields_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public int getConsistencyLevelValue() {
            return this.consistencyLevel_;
        }

        public Builder setConsistencyLevelValue(int value) {
            this.consistencyLevel_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            ConsistencyLevel result = ConsistencyLevel.forNumber(this.consistencyLevel_);
            return result == null ? ConsistencyLevel.UNRECOGNIZED : result;
        }

        public Builder setConsistencyLevel(ConsistencyLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.consistencyLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConsistencyLevel() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.consistencyLevel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getUseDefaultConsistency() {
            return this.useDefaultConsistency_;
        }

        public Builder setUseDefaultConsistency(boolean value) {
            this.useDefaultConsistency_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearUseDefaultConsistency() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.useDefaultConsistency_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

