/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.google.sheets.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.DoNotMock;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import javax.annotation.CheckForNull;
import org.apache.seatunnel.shade.google.sheets.com.google.common.annotations.Beta;
import org.apache.seatunnel.shade.google.sheets.com.google.common.annotations.GwtCompatible;
import org.apache.seatunnel.shade.google.sheets.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.AbstractMapEntry;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.CollectPreconditions;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ImmutableCollection;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ImmutableMapEntrySet;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ImmutableMapKeySet;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ImmutableMapValues;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ImmutableSet;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ImmutableSetMultimap;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.Maps;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.Ordering;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.RegularImmutableMap;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.Sets;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

@DoNotMock(value="Use ImmutableMap.of or another implementation")
@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableSet<K> keySet;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableCollection<V> values;
    @LazyInit
    @CheckForNull
    private transient ImmutableSetMultimap<K, V> multimapView;

    public static <K, V> ImmutableMap<K, V> of() {
        return RegularImmutableMap.EMPTY;
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        return RegularImmutableMap.create(1, new Object[]{k1, v1});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        return RegularImmutableMap.create(2, new Object[]{k1, v1, k2, v2});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        return RegularImmutableMap.create(3, new Object[]{k1, v1, k2, v2, k3, v3});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        return RegularImmutableMap.create(4, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        CollectPreconditions.checkEntryNotNull(k5, v5);
        return RegularImmutableMap.create(5, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4, k5, v5});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        CollectPreconditions.checkEntryNotNull(k5, v5);
        CollectPreconditions.checkEntryNotNull(k6, v6);
        return RegularImmutableMap.create(6, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        CollectPreconditions.checkEntryNotNull(k5, v5);
        CollectPreconditions.checkEntryNotNull(k6, v6);
        CollectPreconditions.checkEntryNotNull(k7, v7);
        return RegularImmutableMap.create(7, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        CollectPreconditions.checkEntryNotNull(k5, v5);
        CollectPreconditions.checkEntryNotNull(k6, v6);
        CollectPreconditions.checkEntryNotNull(k7, v7);
        CollectPreconditions.checkEntryNotNull(k8, v8);
        return RegularImmutableMap.create(8, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        CollectPreconditions.checkEntryNotNull(k5, v5);
        CollectPreconditions.checkEntryNotNull(k6, v6);
        CollectPreconditions.checkEntryNotNull(k7, v7);
        CollectPreconditions.checkEntryNotNull(k8, v8);
        CollectPreconditions.checkEntryNotNull(k9, v9);
        return RegularImmutableMap.create(9, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9});
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        CollectPreconditions.checkEntryNotNull(k1, v1);
        CollectPreconditions.checkEntryNotNull(k2, v2);
        CollectPreconditions.checkEntryNotNull(k3, v3);
        CollectPreconditions.checkEntryNotNull(k4, v4);
        CollectPreconditions.checkEntryNotNull(k5, v5);
        CollectPreconditions.checkEntryNotNull(k6, v6);
        CollectPreconditions.checkEntryNotNull(k7, v7);
        CollectPreconditions.checkEntryNotNull(k8, v8);
        CollectPreconditions.checkEntryNotNull(k9, v9);
        CollectPreconditions.checkEntryNotNull(k10, v10);
        return RegularImmutableMap.create(10, new Object[]{k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9, k10, v10});
    }

    @SafeVarargs
    public static <K, V> ImmutableMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Map.Entry<? extends K, ? extends V>[] entries2 = entries;
        return ImmutableMap.copyOf(Arrays.asList(entries2));
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        CollectPreconditions.checkEntryNotNull(key, value);
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    @Beta
    public static <K, V> Builder<K, V> builderWithExpectedSize(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(expectedSize);
    }

    static void checkNoConflict(boolean safe, String conflictDescription, Object entry1, Object entry2) {
        if (!safe) {
            throw ImmutableMap.conflictException(conflictDescription, entry1, entry2);
        }
    }

    static IllegalArgumentException conflictException(String conflictDescription, Object entry1, Object entry2) {
        String string = String.valueOf(entry1);
        String string2 = String.valueOf(entry2);
        return new IllegalArgumentException(new StringBuilder(34 + String.valueOf(conflictDescription).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("Multiple entries with same ").append(conflictDescription).append(": ").append(string).append(" and ").append(string2).toString());
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableMap kvMap;
        if (map instanceof ImmutableMap && !(map instanceof SortedMap) && !(kvMap = (ImmutableMap)map).isPartialView()) {
            return kvMap;
        }
        return ImmutableMap.copyOf(map.entrySet());
    }

    @Beta
    public static <K, V> ImmutableMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        int initialCapacity = entries instanceof Collection ? ((Collection)entries).size() : 4;
        Builder builder = new Builder(initialCapacity);
        builder.putAll(entries);
        return builder.build();
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    public final V remove(@CheckForNull Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@CheckForNull Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        return ((ImmutableCollection)this.values()).contains(value);
    }

    @Override
    @CheckForNull
    public abstract V get(@CheckForNull Object var1);

    @Override
    @CheckForNull
    public final V getOrDefault(@CheckForNull Object key, @CheckForNull V defaultValue) {
        V result = this.get(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        return result == null ? (this.entrySet = this.createEntrySet()) : result;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    abstract ImmutableSet<K> createKeySet();

    UnmodifiableIterator<K> keyIterator() {
        Iterator entryIterator = ((ImmutableSet)this.entrySet()).iterator();
        return new UnmodifiableIterator<K>(this, (UnmodifiableIterator)entryIterator){
            final /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)this.val$entryIterator.next()).getKey();
            }
        };
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    abstract ImmutableCollection<V> createValues();

    public ImmutableSetMultimap<K, V> asMultimap() {
        if (this.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap<K, V> result = this.multimapView;
        return result == null ? (this.multimapView = new ImmutableSetMultimap(new MapViewOfValuesAsSingletonSets(), this.size(), null)) : result;
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    boolean isHashCodeFast() {
        return false;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    Object writeReplace() {
        return new SerializedForm(this);
    }

    static class SerializedForm<K, V>
    implements Serializable {
        private static final boolean USE_LEGACY_SERIALIZATION = true;
        private final Object keys;
        private final Object values;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<K, V> map) {
            Object[] keys = new Object[map.size()];
            Object[] values = new Object[map.size()];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            this.keys = keys;
            this.values = values;
        }

        final Object readResolve() {
            if (!(this.keys instanceof ImmutableSet)) {
                return this.legacyReadResolve();
            }
            ImmutableSet keySet = (ImmutableSet)this.keys;
            ImmutableCollection values = (ImmutableCollection)this.values;
            Builder builder = this.makeBuilder(keySet.size());
            Iterator keyIter = keySet.iterator();
            Iterator valueIter = values.iterator();
            while (keyIter.hasNext()) {
                builder.put(keyIter.next(), valueIter.next());
            }
            return builder.buildOrThrow();
        }

        final Object legacyReadResolve() {
            Object[] keys = (Object[])this.keys;
            Object[] values = (Object[])this.values;
            Builder<Object, Object> builder = this.makeBuilder(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                builder.put(keys[i], values[i]);
            }
            return builder.buildOrThrow();
        }

        Builder<K, V> makeBuilder(int size) {
            return new Builder(size);
        }
    }

    private final class MapViewOfValuesAsSingletonSets
    extends IteratorBasedImmutableMap<K, ImmutableSet<V>> {
        private MapViewOfValuesAsSingletonSets() {
        }

        @Override
        public int size() {
            return ImmutableMap.this.size();
        }

        @Override
        ImmutableSet<K> createKeySet() {
            return ImmutableMap.this.keySet();
        }

        @Override
        public boolean containsKey(@CheckForNull Object key) {
            return ImmutableMap.this.containsKey(key);
        }

        @Override
        @CheckForNull
        public ImmutableSet<V> get(@CheckForNull Object key) {
            Object outerValue = ImmutableMap.this.get(key);
            return outerValue == null ? null : ImmutableSet.of(outerValue);
        }

        @Override
        boolean isPartialView() {
            return ImmutableMap.this.isPartialView();
        }

        @Override
        public int hashCode() {
            return ImmutableMap.this.hashCode();
        }

        @Override
        boolean isHashCodeFast() {
            return ImmutableMap.this.isHashCodeFast();
        }

        @Override
        UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>> entryIterator() {
            final Iterator backingIterator = ((ImmutableSet)ImmutableMap.this.entrySet()).iterator();
            return new UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>>(this){

                @Override
                public boolean hasNext() {
                    return backingIterator.hasNext();
                }

                @Override
                public Map.Entry<K, ImmutableSet<V>> next() {
                    final Map.Entry backingEntry = (Map.Entry)backingIterator.next();
                    return new AbstractMapEntry<K, ImmutableSet<V>>(this){

                        @Override
                        public K getKey() {
                            return backingEntry.getKey();
                        }

                        @Override
                        public ImmutableSet<V> getValue() {
                            return ImmutableSet.of(backingEntry.getValue());
                        }
                    };
                }
            };
        }
    }

    static abstract class IteratorBasedImmutableMap<K, V>
    extends ImmutableMap<K, V> {
        IteratorBasedImmutableMap() {
        }

        abstract UnmodifiableIterator<Map.Entry<K, V>> entryIterator();

        @Override
        ImmutableSet<K> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<K, V>> createEntrySet() {
            class EntrySetImpl
            extends ImmutableMapEntrySet<K, V> {
                EntrySetImpl() {
                }

                @Override
                ImmutableMap<K, V> map() {
                    return IteratorBasedImmutableMap.this;
                }

                @Override
                public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                    return IteratorBasedImmutableMap.this.entryIterator();
                }
            }
            return new EntrySetImpl();
        }

        @Override
        ImmutableCollection<V> createValues() {
            return new ImmutableMapValues(this);
        }
    }

    @DoNotMock
    public static class Builder<K, V> {
        @CheckForNull
        Comparator<? super V> valueComparator;
        @Nullable Object[] alternatingKeysAndValues;
        int size;
        boolean entriesUsed;
        @Nullable DuplicateKey duplicateKey;

        public Builder() {
            this(4);
        }

        Builder(int initialCapacity) {
            this.alternatingKeysAndValues = new Object[2 * initialCapacity];
            this.size = 0;
            this.entriesUsed = false;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity * 2 > this.alternatingKeysAndValues.length) {
                this.alternatingKeysAndValues = Arrays.copyOf(this.alternatingKeysAndValues, ImmutableCollection.Builder.expandedCapacity(this.alternatingKeysAndValues.length, minCapacity * 2));
                this.entriesUsed = false;
            }
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            this.ensureCapacity(this.size + 1);
            CollectPreconditions.checkEntryNotNull(key, value);
            this.alternatingKeysAndValues[2 * this.size] = key;
            this.alternatingKeysAndValues[2 * this.size + 1] = value;
            ++this.size;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            return this.putAll(map.entrySet());
        }

        @CanIgnoreReturnValue
        @Beta
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            if (entries instanceof Collection) {
                this.ensureCapacity(this.size + ((Collection)entries).size());
            }
            for (Map.Entry<K, V> entry : entries) {
                this.put(entry);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @Beta
        public Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            Preconditions.checkState(this.valueComparator == null, "valueComparator was already set");
            this.valueComparator = Preconditions.checkNotNull(valueComparator, "valueComparator");
            return this;
        }

        @CanIgnoreReturnValue
        Builder<K, V> combine(Builder<K, V> other) {
            Preconditions.checkNotNull(other);
            this.ensureCapacity(this.size + other.size);
            System.arraycopy(other.alternatingKeysAndValues, 0, this.alternatingKeysAndValues, this.size * 2, other.size * 2);
            this.size += other.size;
            return this;
        }

        private ImmutableMap<K, V> build(boolean throwIfDuplicateKeys) {
            Object[] localAlternatingKeysAndValues;
            if (throwIfDuplicateKeys && this.duplicateKey != null) {
                throw this.duplicateKey.exception();
            }
            int localSize = this.size;
            if (this.valueComparator == null) {
                localAlternatingKeysAndValues = this.alternatingKeysAndValues;
            } else {
                if (this.entriesUsed) {
                    this.alternatingKeysAndValues = Arrays.copyOf(this.alternatingKeysAndValues, 2 * this.size);
                }
                localAlternatingKeysAndValues = this.alternatingKeysAndValues;
                if (!throwIfDuplicateKeys && (localAlternatingKeysAndValues = this.lastEntryForEachKey(localAlternatingKeysAndValues, this.size)).length < this.alternatingKeysAndValues.length) {
                    localSize = localAlternatingKeysAndValues.length >>> 1;
                }
                Builder.sortEntries(localAlternatingKeysAndValues, localSize, this.valueComparator);
            }
            this.entriesUsed = true;
            RegularImmutableMap map = RegularImmutableMap.create(localSize, localAlternatingKeysAndValues, this);
            if (throwIfDuplicateKeys && this.duplicateKey != null) {
                throw this.duplicateKey.exception();
            }
            return map;
        }

        public ImmutableMap<K, V> build() {
            return this.buildOrThrow();
        }

        public ImmutableMap<K, V> buildOrThrow() {
            return this.build(true);
        }

        public ImmutableMap<K, V> buildKeepingLast() {
            return this.build(false);
        }

        static <V> void sortEntries(@Nullable Object[] alternatingKeysAndValues, int size, Comparator<? super V> valueComparator) {
            int i;
            Map.Entry[] entries = new Map.Entry[size];
            for (i = 0; i < size; ++i) {
                Object key = Objects.requireNonNull(alternatingKeysAndValues[2 * i]);
                Object value = Objects.requireNonNull(alternatingKeysAndValues[2 * i + 1]);
                entries[i] = new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
            }
            Arrays.sort(entries, 0, size, Ordering.from(valueComparator).onResultOf(Maps.valueFunction()));
            for (i = 0; i < size; ++i) {
                alternatingKeysAndValues[2 * i] = entries[i].getKey();
                alternatingKeysAndValues[2 * i + 1] = entries[i].getValue();
            }
        }

        private @Nullable Object[] lastEntryForEachKey(@Nullable Object[] localAlternatingKeysAndValues, int size) {
            HashSet<Object> seenKeys = new HashSet<Object>();
            BitSet dups = new BitSet();
            for (int i = size - 1; i >= 0; --i) {
                Object key = Objects.requireNonNull(localAlternatingKeysAndValues[2 * i]);
                if (seenKeys.add(key)) continue;
                dups.set(i);
            }
            if (dups.isEmpty()) {
                return localAlternatingKeysAndValues;
            }
            Object[] newAlternatingKeysAndValues = new Object[(size - dups.cardinality()) * 2];
            int inI = 0;
            int outI = 0;
            while (inI < size * 2) {
                if (dups.get(inI >>> 1)) {
                    inI += 2;
                    continue;
                }
                newAlternatingKeysAndValues[outI++] = Objects.requireNonNull(localAlternatingKeysAndValues[inI++]);
                newAlternatingKeysAndValues[outI++] = Objects.requireNonNull(localAlternatingKeysAndValues[inI++]);
            }
            return newAlternatingKeysAndValues;
        }

        static final class DuplicateKey {
            private final Object key;
            private final Object value1;
            private final Object value2;

            DuplicateKey(Object key, Object value1, Object value2) {
                this.key = key;
                this.value1 = value1;
                this.value2 = value2;
            }

            IllegalArgumentException exception() {
                String string = String.valueOf(this.key);
                String string2 = String.valueOf(this.value1);
                String string3 = String.valueOf(this.key);
                String string4 = String.valueOf(this.value2);
                return new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Multiple entries with same key: ").append(string).append("=").append(string2).append(" and ").append(string3).append("=").append(string4).toString());
            }
        }
    }
}

