/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseMultipleTableFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.FileSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleTableFileSourceReader
implements SourceReader<SeaTunnelRow, FileSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(MultipleTableFileSourceReader.class);
    private final SourceReader.Context context;
    private volatile boolean noMoreSplit;
    private final Deque<FileSourceSplit> sourceSplits = new ConcurrentLinkedDeque<FileSourceSplit>();
    private final Map<String, ReadStrategy> readStrategyMap;

    public MultipleTableFileSourceReader(SourceReader.Context context, BaseMultipleTableFileSourceConfig multipleTableFileSourceConfig) {
        this.context = context;
        this.readStrategyMap = multipleTableFileSourceConfig.getFileSourceConfigs().stream().collect(Collectors.toMap(fileSourceConfig -> fileSourceConfig.getCatalogTable().getTableId().toTablePath().toString(), BaseFileSourceConfig::getReadStrategy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) {
        Object object = output.getCheckpointLock();
        synchronized (object) {
            FileSourceSplit split = this.sourceSplits.poll();
            if (null != split) {
                ReadStrategy readStrategy = this.readStrategyMap.get(split.getTableId());
                if (readStrategy == null) {
                    throw new FileConnectorException((SeaTunnelErrorCode)FileConnectorErrorCode.FILE_READ_STRATEGY_NOT_SUPPORT, "Cannot found the read strategy for this table: [" + split.getTableId() + "]");
                }
                try {
                    readStrategy.read(split.getFilePath(), split.getTableId(), output);
                }
                catch (Exception e) {
                    String errorMsg = String.format("Read data from this file [%s] failed", split.splitId());
                    throw new FileConnectorException(FileConnectorErrorCode.FILE_READ_FAILED, errorMsg, e);
                }
            } else if (this.noMoreSplit && this.sourceSplits.isEmpty()) {
                log.info("There is no more element for the bounded MultipleTableLocalFileSourceReader");
                this.context.signalNoMoreElement();
            }
        }
    }

    public List<FileSourceSplit> snapshotState(long checkpointId) {
        return new ArrayList<FileSourceSplit>(this.sourceSplits);
    }

    public void addSplits(List<FileSourceSplit> splits) {
        this.sourceSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void open() throws Exception {
        log.info("Opened the MultipleTableLocalFileSourceReader");
    }

    public void close() throws IOException {
        log.info("Closed the MultipleTableLocalFileSourceReader");
        for (ReadStrategy strategy : this.readStrategyMap.values()) {
            strategy.close();
        }
    }
}

