/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.oss.config;

import java.util.HashMap;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.oss.config.OssFileBaseOptions;

public class OssHadoopConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem";
    private static final String SCHEMA = "oss";

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public OssHadoopConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    public static HadoopConf buildWithConfig(ReadonlyConfig config) {
        OssHadoopConf hadoopConf = new OssHadoopConf((String)config.get(OssFileBaseOptions.BUCKET));
        HashMap<String, String> ossOptions = new HashMap<String, String>();
        ossOptions.put("fs.oss.accessKeyId", (String)config.get(OssFileBaseOptions.ACCESS_KEY));
        ossOptions.put("fs.oss.accessKeySecret", (String)config.get(OssFileBaseOptions.ACCESS_SECRET));
        ossOptions.put("fs.oss.endpoint", (String)config.get(OssFileBaseOptions.ENDPOINT));
        hadoopConf.setExtraOptions(ossOptions);
        return hadoopConf;
    }
}

