/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.orc;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.EncryptionAlgorithm;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.impl.HadoopShims;

public class InMemoryKeystore
implements HadoopShims.KeyProvider {
    public static final boolean SUPPORTS_AES_256;
    private static final String LOCAL_KEY_CIPHER = "/CBC/NoPadding";
    private final Random random;
    private final TreeMap<String, KeyVersion> keys = new TreeMap();
    private final Map<String, Integer> currentVersion = new HashMap<String, Integer>();

    public InMemoryKeystore() {
        this.random = new SecureRandom();
    }

    public InMemoryKeystore(Random random) {
        this.random = random;
    }

    protected static String buildVersionName(String name, int version) {
        return name + "@" + version;
    }

    @Override
    public List<String> getKeyNames() {
        return new ArrayList<String>(this.currentVersion.keySet());
    }

    @Override
    public HadoopShims.KeyMetadata getCurrentKeyVersion(String keyName) {
        String versionName = InMemoryKeystore.buildVersionName(keyName, this.currentVersion.get(keyName));
        if (this.keys.containsKey(versionName)) {
            return this.keys.get(versionName);
        }
        throw new IllegalArgumentException("Unknown key " + keyName);
    }

    @Override
    public HadoopShims.LocalKey createLocalKey(HadoopShims.KeyMetadata key) {
        Cipher localCipher;
        String keyVersion = InMemoryKeystore.buildVersionName(key.getKeyName(), key.getVersion());
        if (!this.keys.containsKey(keyVersion)) {
            throw new IllegalArgumentException("Unknown key " + key);
        }
        KeyVersion secret = this.keys.get(keyVersion);
        EncryptionAlgorithm algorithm = secret.getAlgorithm();
        byte[] unecryptedKey = new byte[algorithm.keyLength()];
        this.random.nextBytes(unecryptedKey);
        byte[] iv = new byte[algorithm.getIvLength()];
        String cipherName = algorithm.getAlgorithm() + LOCAL_KEY_CIPHER;
        try {
            localCipher = Cipher.getInstance(cipherName);
            localCipher.init(1, (Key)new SecretKeySpec(secret.getMaterial(), algorithm.getAlgorithm()), new IvParameterSpec(iv));
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("ORC bad padding for " + cipherName, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("ORC bad algorithm for " + cipherName, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("ORC bad encryption key for " + keyVersion, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException("ORC bad encryption parameter for " + keyVersion, e);
        }
        try {
            byte[] encryptedKey = localCipher.doFinal(unecryptedKey);
            return new HadoopShims.LocalKey(new SecretKeySpec(unecryptedKey, algorithm.getAlgorithm()), encryptedKey);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("ORC bad block size for " + keyVersion, e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("ORC bad padding for " + keyVersion, e);
        }
    }

    @Override
    public Key decryptLocalKey(HadoopShims.KeyMetadata key, byte[] encryptedKey) {
        Cipher localCipher;
        String keyVersion = InMemoryKeystore.buildVersionName(key.getKeyName(), key.getVersion());
        if (!this.keys.containsKey(keyVersion)) {
            return null;
        }
        KeyVersion secret = this.keys.get(keyVersion);
        EncryptionAlgorithm algorithm = secret.getAlgorithm();
        byte[] iv = new byte[algorithm.getIvLength()];
        String cipherName = algorithm.getAlgorithm() + LOCAL_KEY_CIPHER;
        try {
            localCipher = Cipher.getInstance(cipherName);
            localCipher.init(2, (Key)new SecretKeySpec(secret.getMaterial(), algorithm.getAlgorithm()), new IvParameterSpec(iv));
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("ORC bad padding for " + cipherName, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("ORC bad algorithm for " + cipherName, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("ORC bad encryption key for " + keyVersion, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException("ORC bad encryption parameter for " + keyVersion, e);
        }
        try {
            byte[] decryptedKey = localCipher.doFinal(encryptedKey);
            return new SecretKeySpec(decryptedKey, algorithm.getAlgorithm());
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("ORC bad block size for " + keyVersion, e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("ORC bad padding for " + keyVersion, e);
        }
    }

    public InMemoryKeystore addKey(String keyName, EncryptionAlgorithm algorithm, byte[] masterKey) throws IOException {
        return this.addKey(keyName, 0, algorithm, masterKey);
    }

    public InMemoryKeystore addKey(String keyName, int version, EncryptionAlgorithm algorithm, byte[] masterKey) throws IOException {
        if (!SUPPORTS_AES_256 && algorithm != EncryptionAlgorithm.AES_128) {
            algorithm = EncryptionAlgorithm.AES_128;
        }
        byte[] buffer = new byte[algorithm.keyLength()];
        if (algorithm.keyLength() > masterKey.length) {
            System.arraycopy(masterKey, 0, buffer, 0, masterKey.length);
            Arrays.fill(buffer, masterKey.length, buffer.length - 1, (byte)0);
        } else {
            System.arraycopy(masterKey, 0, buffer, 0, algorithm.keyLength());
        }
        KeyVersion key = new KeyVersion(keyName, version, algorithm, buffer);
        if (this.currentVersion.get(keyName) != null && this.currentVersion.get(keyName) >= version) {
            throw new IOException(String.format("Key %s with equal or higher version %d already exists", keyName, version));
        }
        this.keys.put(InMemoryKeystore.buildVersionName(keyName, version), key);
        this.currentVersion.put(keyName, version);
        return this;
    }

    static {
        try {
            SUPPORTS_AES_256 = Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unknown algorithm", e);
        }
    }

    static class KeyVersion
    extends HadoopShims.KeyMetadata {
        private final byte[] material;

        public KeyVersion(String keyName, int version, EncryptionAlgorithm algorithm, byte[] material) {
            super(keyName, version, algorithm);
            this.material = material;
        }

        public byte[] getMaterial() {
            return this.material;
        }
    }
}

