/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.ftp.config;

import java.util.HashMap;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpFileBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.system.FtpConnectionMode;

public class FtpConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.seatunnel.connectors.seatunnel.file.ftp.system.SeaTunnelFTPFileSystem";
    private static final String SCHEMA = "ftp";

    public FtpConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public static HadoopConf buildWithConfig(ReadonlyConfig config) {
        String host = (String)config.get(FtpFileBaseOptions.FTP_HOST);
        int port = (Integer)config.get(FtpFileBaseOptions.FTP_PORT);
        String defaultFS = String.format("ftp://%s:%s", host, port);
        FtpConf hadoopConf = new FtpConf(defaultFS);
        HashMap<String, String> ftpOptions = new HashMap<String, String>();
        ftpOptions.put("fs.ftp.user." + host, (String)config.get(FtpFileBaseOptions.FTP_USERNAME));
        ftpOptions.put("fs.ftp.password." + host, (String)config.get(FtpFileBaseOptions.FTP_PASSWORD));
        Optional optional = config.getOptional(FtpFileBaseOptions.FTP_CONNECTION_MODE);
        if (optional.isPresent()) {
            ftpOptions.put("fs.ftp.connection.mode", ((FtpConnectionMode)((Object)config.get(FtpFileBaseOptions.FTP_CONNECTION_MODE))).toString());
        }
        ftpOptions.put("fs.ftp.remote.verification.enabled", String.valueOf(config.get(FtpFileBaseOptions.FTP_REMOTE_VERIFICATION_ENABLED)));
        hadoopConf.setExtraOptions(ftpOptions);
        return hadoopConf;
    }
}

