/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.AuthTypeEnum;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSource;

@AutoService(value={Factory.class})
public class ElasticsearchSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Elasticsearch";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{ElasticsearchBaseOptions.HOSTS}).optional(new Option[]{ElasticsearchBaseOptions.INDEX, ElasticsearchSourceOptions.INDEX_LIST, ElasticsearchBaseOptions.USERNAME, ElasticsearchBaseOptions.PASSWORD, ElasticsearchSourceOptions.SCROLL_TIME, ElasticsearchSourceOptions.SCROLL_SIZE, ElasticsearchSourceOptions.QUERY, ElasticsearchSourceOptions.PIT_KEEP_ALIVE, ElasticsearchSourceOptions.PIT_BATCH_SIZE, ElasticsearchSourceOptions.SEARCH_API_TYPE, ElasticsearchSourceOptions.SEARCH_TYPE, ElasticsearchBaseOptions.TLS_VERIFY_CERTIFICATE, ElasticsearchBaseOptions.TLS_VERIFY_HOSTNAME, ElasticsearchBaseOptions.TLS_KEY_STORE_PATH, ElasticsearchBaseOptions.TLS_KEY_STORE_PASSWORD, ElasticsearchBaseOptions.TLS_TRUST_STORE_PATH, ElasticsearchBaseOptions.TLS_TRUST_STORE_PASSWORD}).optional(new Option[]{ElasticsearchBaseOptions.AUTH_TYPE}).conditional(ElasticsearchBaseOptions.AUTH_TYPE, (Object)AuthTypeEnum.API_KEY, new Option[]{ElasticsearchBaseOptions.API_KEY_ID, ElasticsearchBaseOptions.API_KEY}).conditional(ElasticsearchBaseOptions.AUTH_TYPE, (Object)AuthTypeEnum.API_KEY_ENCODED, new Option[]{ElasticsearchBaseOptions.API_KEY_ENCODED}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new ElasticsearchSource(context.getOptions());
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return ElasticsearchSource.class;
    }
}

